/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import javax.annotation.Nullable;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mod.config.Config;
import org.mtr.mod.generated.resource.RailResourceSchema;
import org.mtr.mod.render.DynamicVehicleModel;
import org.mtr.mod.resource.CachedResource;
import org.mtr.mod.resource.CustomResourceTools;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.ResourceProvider;
import org.mtr.mod.resource.StoredModelResourceBase;

public final class RailResource
extends RailResourceSchema
implements StoredModelResourceBase {
    public final boolean shouldPreload;
    private final CachedResource<ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel>> cachedRailResource;

    public RailResource(ReaderBase readerBase, ResourceProvider resourceProvider) {
        super(readerBase, resourceProvider);
        this.updateData(readerBase);
        this.shouldPreload = Config.getClient().matchesPreloadResourcePattern(this.id);
        this.cachedRailResource = new CachedResource<ObjectObjectImmutablePair>(() -> this.load(this.modelResource, this.textureResource, this.flipTextureV, this.modelYOffset, resourceProvider), this.shouldPreload ? Integer.MAX_VALUE : 60000L);
    }

    public RailResource(String id, String name, ResourceProvider resourceProvider) {
        super(id, name, "777777", "", "", false, 0.0, 0.0, resourceProvider);
        this.shouldPreload = false;
        this.cachedRailResource = new CachedResource<ObjectObjectImmutablePair>(() -> null, Integer.MAX_VALUE);
    }

    @Override
    @Nullable
    public OptimizedModelWrapper getOptimizedModel() {
        ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel> railResource = this.cachedRailResource.getData(false);
        return railResource == null ? null : railResource.left();
    }

    @Override
    @Nullable
    public DynamicVehicleModel getDynamicVehicleModel() {
        ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel> railResource = this.cachedRailResource.getData(false);
        return railResource == null ? null : railResource.right();
    }

    @Override
    public void preload() {
        this.cachedRailResource.getData(true);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return CustomResourceTools.colorStringToInt(this.color);
    }

    public double getRepeatInterval() {
        return this.repeatInterval;
    }

    public double getModelYOffset() {
        return this.modelYOffset;
    }

    public static String getIdWithoutDirection(String id) {
        return id.endsWith("_1") || id.endsWith("_2") ? id.substring(0, id.length() - 2) : id;
    }
}

