/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.class_339;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockTrainScheduleSensor;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateTrainScheduleSensorConfig;
import org.mtr.mod.screen.TrainSensorScreenBase;

public class TrainScheduleSensorScreen
extends TrainSensorScreenBase {
    private final int seconds;
    private final boolean realtimeOnly;
    private final CheckboxWidgetExtension realtimeOnlyCheckbox;
    private static final int MAX_SECONDS_LENGTH = 5;
    private static final int DEFAULT_SECONDS = 10;

    public TrainScheduleSensorScreen(BlockPos pos, BlockTrainScheduleSensor.BlockEntity blockEntity) {
        super(pos, false, new ObjectObjectImmutablePair<TextFieldWidgetExtension, MutableText>(new TextFieldWidgetExtension(0, 0, 0, 20, 5, TextCase.DEFAULT, "[^\\d-]", null), TranslationProvider.GUI_MTR_TRAIN_SCHEDULE_SENSOR.getMutableText(new Object[0])));
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            this.seconds = 10;
            this.realtimeOnly = false;
        } else {
            this.seconds = blockEntity.getSeconds();
            this.realtimeOnly = blockEntity.getRealtimeOnly();
        }
        this.realtimeOnlyCheckbox = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {});
        this.realtimeOnlyCheckbox.setMessage2(TranslationProvider.GUI_MTR_REALTIME_ONLY.getText(new Object[0]));
    }

    @Override
    protected void init2() {
        super.init2();
        this.textFields[0].setText2(String.valueOf(this.seconds));
        IDrawing.setPositionAndWidth(this.realtimeOnlyCheckbox, 20, 58, 144);
        this.realtimeOnlyCheckbox.setChecked(this.realtimeOnly);
        this.addChild(new ClickableWidget((class_339)this.realtimeOnlyCheckbox));
    }

    @Override
    protected void sendUpdate(BlockPos blockPos, LongAVLTreeSet filterRouteIds, boolean stoppedOnly, boolean movingOnly) {
        int secondsParsed = 10;
        try {
            secondsParsed = Integer.parseInt(this.textFields[0].getText2());
        }
        catch (Exception exception) {
            // empty catch block
        }
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateTrainScheduleSensorConfig(blockPos, filterRouteIds, stoppedOnly, movingOnly, secondsParsed, this.realtimeOnlyCheckbox.isChecked2()));
    }
}

