/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicate;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BiomeEntityModelPredicate
implements EntityModelPredicate {
    public static final Serializer<BiomeEntityModelPredicate> SERIALIZER = new Serializer<BiomeEntityModelPredicate>(){

        @Override
        public BiomeEntityModelPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("biomes") || !json.get("biomes").isJsonArray()) {
                throw new JsonParseException("Biome-predicate must have array property 'biomes'!");
            }
            HashSet<class_2960> biomes = new HashSet<class_2960>();
            for (JsonElement element : json.getAsJsonArray("biomes")) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array property 'biomes' must only contain strings!");
                }
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Biome entries must be a valid identifier, not '" + element.getAsString() + "'!");
                }
                biomes.add(new class_2960(element.getAsString()));
            }
            return new BiomeEntityModelPredicate(biomes);
        }

        @Override
        public JsonObject serialize(BiomeEntityModelPredicate value) {
            JsonObject json = new JsonObject();
            JsonArray biomes = new JsonArray(value.biomes.size());
            value.biomes.stream().map(class_2960::toString).sorted().forEach(arg_0 -> ((JsonArray)biomes).add(arg_0));
            json.add("biomes", (JsonElement)biomes);
            return json;
        }
    };
    private final Set<class_2960> biomes;
    private class_5455 registry;
    private Set<class_6880<class_1959>> holders;

    public BiomeEntityModelPredicate(Set<class_2960> biomes) {
        this.biomes = Set.copyOf(biomes);
    }

    @Override
    public boolean test(class_1297 entity) {
        if (this.biomes.isEmpty()) {
            return false;
        }
        class_1937 level = entity.method_37908();
        if (level == null) {
            return false;
        }
        if (level.method_30349() != this.registry) {
            this.registry = level.method_30349();
            class_2378 biomeRegistry = this.registry.method_30530(class_7924.field_41236);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (class_2960 biome : this.biomes) {
                biomeRegistry.method_40264(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biome)).ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
            }
            this.holders = builder.build();
        }
        if (this.holders == null || this.holders.isEmpty()) {
            return false;
        }
        class_6880 biome = level.method_23753(entity.method_24515());
        return biome != null && this.holders.contains(biome);
    }

    @Override
    public Serializer<? extends EntityModelPredicate> getSerializer() {
        return SERIALIZER;
    }
}

