/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.impl.ObjectUtilsImpl;
import com.apple.library.impl.ReversedIteratorImpl;
import com.apple.library.impl.ViewImpl;
import com.apple.library.quartzcore.CALayer;
import com.apple.library.quartzcore.CATransaction;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIPresentationDelegate;
import com.apple.library.uikit.UIResponder;
import com.apple.library.uikit.UIWindow;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class UIView
extends UIResponder
implements ViewImpl {
    protected final Flags _flags = new Flags();
    protected final ArrayList<UIView> _subviews = new ArrayList();
    protected final CALayer _layer = new CALayer();
    protected final UIPresentationDelegate _presentation = new UIPresentationDelegate(this);
    private WeakReference<UIView> _superview;
    private WeakReference<UIWindow> _window;
    private Object _tooltip;
    private UIColor _backgroundColor;
    private CGPoint _center = CGPoint.ZERO;
    private CGRect _bounds = CGRect.ZERO;
    private CGRect _frame = CGRect.ZERO;
    private CGAffineTransform _transform = CGAffineTransform.IDENTITY;
    private CGAffineTransform _invertedTransform = CGAffineTransform.IDENTITY;
    private int _tag = 0;
    private int _zIndex = 0;
    private int _autoresizingMask = 0;

    public UIView(CGRect frame) {
        this.setFrame(frame);
    }

    public static void animationWithDuration(double duration, Runnable animations) {
        UIView.animationWithDuration(duration, 0, animations, null);
    }

    public static void animationWithDuration(double duration, Runnable animations, @Nullable Consumer<Boolean> completion) {
        UIView.animationWithDuration(duration, 0, animations, completion);
    }

    public static void animationWithDuration(double duration, int options, Runnable animations, @Nullable Consumer<Boolean> completion) {
        CATransaction.begin();
        CATransaction.setAnimationDuration(duration);
        if (completion != null) {
            CATransaction.setCompletionBlock(() -> completion.accept(true));
        }
        animations.run();
        CATransaction.commit();
    }

    public void addSubview(UIView view) {
        this._insertViewAtIndex(view, this._subviews.size());
    }

    public void insertViewAtIndex(UIView view, int index) {
        this._insertViewAtIndex(view, index);
    }

    public void removeFromSuperview() {
        UIView superview = this.superview();
        if (superview == null) {
            return;
        }
        superview._subviews.remove(this);
        this._setSuperview(null);
    }

    public void bringSubviewToFront(UIView view) {
        if (this._subviews.remove(view)) {
            this._subviews.add(view);
        }
    }

    public void sendSubviewToBack(UIView view) {
        if (this._subviews.remove(view)) {
            this._subviews.add(0, view);
        }
    }

    public void layoutSubviews() {
    }

    public void layoutIfNeeded() {
        if (!this._flags.isDirty) {
            return;
        }
        if (this._flags.needsLayout) {
            this.layoutSubviews();
        }
        for (UIView subview : this.subviews()) {
            subview.layoutIfNeeded();
        }
        this._flags.isDirty = false;
        this._flags.needsLayout = false;
    }

    public void render(CGPoint point, CGGraphicsContext context) {
        context.drawContents(this._layer.contents(), this.bounds(), this);
    }

    public boolean pointInside(CGPoint point, UIEvent event) {
        CGRect rect = this.bounds();
        return rect.contains(point);
    }

    @Nullable
    public UIView hitTest(CGPoint point, UIEvent event) {
        if (this._ignoresTouchEvents(this)) {
            return null;
        }
        if (!this.pointInside(point, event)) {
            return null;
        }
        for (UIView subview : this._invertedSubviews()) {
            UIView hitView = subview.hitTest(this.convertPointToView(point, subview), event);
            if (hitView == null) continue;
            return hitView;
        }
        return this;
    }

    public void willMoveToSuperview(UIView newSuperview) {
    }

    public void didMoveToSuperview() {
    }

    public void willMoveToWindow(UIWindow newWindow) {
    }

    public void didMoveToWindow() {
    }

    public void layerWillDraw(CGGraphicsContext context) {
    }

    public void layerDidDraw(CGGraphicsContext context) {
    }

    public void focusesDidChange() {
    }

    public void sizeToFit() {
        this._setSize(this.sizeThatFits(this.bounds().size()));
    }

    public CGSize sizeThatFits(CGSize size) {
        return size;
    }

    public boolean isDescendantOfView(UIView superview) {
        for (UIView searchingView = this; searchingView != null; searchingView = searchingView.superview()) {
            if (searchingView != superview) continue;
            return true;
        }
        return false;
    }

    @Override
    public UIResponder nextResponder() {
        return this.superview();
    }

    public Object tooltip() {
        return this._tooltip;
    }

    @Nullable
    public final UIView superview() {
        if (this._superview != null) {
            return (UIView)this._superview.get();
        }
        return null;
    }

    @Nullable
    public final UIWindow window() {
        if (this._window != null) {
            return (UIWindow)this._window.get();
        }
        return null;
    }

    public final List<UIView> subviews() {
        return this._subviews;
    }

    public UIColor backgroundColor() {
        return this._backgroundColor;
    }

    @Override
    public CGPoint center() {
        return this._center;
    }

    @Override
    public CGRect bounds() {
        return this._bounds;
    }

    public CGRect frame() {
        if (this._frame == null) {
            this._frame = this._remakeFrame();
        }
        return this._frame;
    }

    @Override
    public CGAffineTransform transform() {
        return this._transform;
    }

    public CALayer layer() {
        return this._layer;
    }

    public boolean canBecomeFocused() {
        return false;
    }

    public boolean isFocused() {
        return this._flags.isFocused;
    }

    public boolean shouldBecomeFocused(UIView subview) {
        return true;
    }

    public void setCenter(CGPoint center) {
        CGPoint oldValue = this._center;
        if (this._center.equals(center)) {
            return;
        }
        this._frame = null;
        this._center = center;
        this._presentation.addAnimationForKeyPath(oldValue, center, "center");
    }

    public void setBounds(CGRect bounds) {
        CGRect oldValue = this.bounds();
        if (oldValue.equals(bounds)) {
            return;
        }
        this._frame = null;
        this._bounds = bounds;
        if (this._flags.needsAutoresizing) {
            this._resizeSubviewsWithOldSize(oldValue, this.bounds());
        }
        this._sizeDidChange();
        this._presentation.addAnimationForKeyPath(oldValue, bounds, "bounds");
    }

    public void setFrame(CGRect frame) {
        if (this.frame().equals(frame)) {
            return;
        }
        CGRect bounds = this.bounds().copy();
        CGPoint center = new CGPoint(frame.x + frame.width * 0.5f, frame.y + frame.height * 0.5f);
        bounds.width = frame.width;
        bounds.height = frame.height;
        if (this._transform != CGAffineTransform.IDENTITY) {
            CGSize size = frame.size();
            size.apply(this._invertedTransform());
            bounds.width = size.width;
            bounds.height = size.height;
        }
        this.setCenter(center);
        this.setBounds(bounds);
    }

    public void setTransform(CGAffineTransform transform) {
        CGAffineTransform oldValue = this._transform;
        if (this._transform.equals(transform)) {
            return;
        }
        this._transform = transform;
        this._invertedTransform = null;
        this._frame = null;
        this._presentation.addAnimationForKeyPath(oldValue, transform, "transform");
    }

    public void setTooltip(Object tooltip) {
        this._tooltip = tooltip;
    }

    public void setBackgroundColor(UIColor backgroundColor) {
        this._backgroundColor = backgroundColor;
    }

    public boolean isHidden() {
        return this._layer.isHidden();
    }

    public void setHidden(boolean isHidden) {
        this._layer.setHidden(isHidden);
    }

    public boolean isOpaque() {
        return this._layer.isOpaque();
    }

    public void setOpaque(boolean opaque) {
        this._layer.setOpaque(opaque);
    }

    public float alpha() {
        return this._layer.opacity();
    }

    public void setAlpha(float alpha) {
        this._layer.setOpacity(alpha);
    }

    public int zIndex() {
        return this._zIndex;
    }

    public void setZIndex(int zIndex) {
        this._zIndex = zIndex;
    }

    public boolean isClipBounds() {
        return this._layer.masksToBounds();
    }

    public void setClipBounds(boolean clipBounds) {
        this._layer.setMasksToBounds(clipBounds);
    }

    public boolean isUserInteractionEnabled() {
        return this._flags.isUserInteractionEnabled;
    }

    public void setUserInteractionEnabled(boolean isUserInteractionEnabled) {
        this._flags.isUserInteractionEnabled = isUserInteractionEnabled;
    }

    public int autoresizingMask() {
        return this._autoresizingMask;
    }

    public void setAutoresizingMask(int autoresizingMask) {
        this._autoresizingMask = autoresizingMask;
        UIView superview = this.superview();
        if (superview != null) {
            superview._setAutoresizingFlagsDirty();
        }
    }

    public int tag() {
        return this._tag;
    }

    public void setTag(int tag) {
        this._tag = tag;
    }

    public Object contents() {
        return this._layer.contents();
    }

    public void setContents(Object contents) {
        this._layer.setContents(contents);
    }

    public void setNeedsLayout() {
        this._flags.needsLayout = true;
        this._setDirty();
    }

    @Override
    public UIView self() {
        return this;
    }

    public String toString() {
        return ObjectUtilsImpl.makeDescription(this, "frame", this.frame(), "transform", this._transform);
    }

    private void _setDirty() {
        this._flags.isDirty = true;
        UIView superview = this.superview();
        if (superview != null && !superview._flags.isDirty) {
            superview._setDirty();
        }
    }

    private void _setAutoresizingFlagsDirty() {
        this._flags.needsAutoresizing = this.subviews().stream().anyMatch(view -> view.autoresizingMask() != 0);
    }

    private void _insertViewAtIndex(UIView view, int index) {
        if (this == view) {
            throw new RuntimeException("Can't add self");
        }
        if (view._superview != null) {
            view.removeFromSuperview();
        }
        if (index < this._subviews.size()) {
            this._subviews.add(index, view);
        } else {
            this._subviews.add(view);
        }
        view._setSuperview(this);
    }

    private void _resizeSubviewsWithOldSize(CGRect oldValue, CGRect newValue) {
        for (UIView subview : this.subviews()) {
            subview._resizeWithOldSuperviewSize(oldValue, newValue);
        }
    }

    private void _resizeWithOldSuperviewSize(CGRect oldParentValue, CGRect newParentValue) {
        float[] v;
        int mask = this.autoresizingMask();
        if (mask == 0) {
            return;
        }
        CGRect frame = this.frame();
        float[] h = this._applyAutoresizingMask(frame.x, frame.width, newParentValue.width, oldParentValue.width, mask);
        CGRect newFrame = new CGRect(h[0], (v = this._applyAutoresizingMask(frame.y, frame.height, newParentValue.height, oldParentValue.height, mask >> 3))[0], h[1], v[1]);
        if (!newFrame.equals(frame)) {
            this.setFrame(newFrame);
        }
    }

    private void _sizeDidChange() {
        this.setNeedsLayout();
        UIView superview = this.superview();
        if (superview != null) {
            superview.setNeedsLayout();
        }
    }

    private void _setSuperview(UIView newSuperview) {
        if (this.superview() == newSuperview) {
            return;
        }
        this.willMoveToSuperview(newSuperview);
        this._superview = new WeakReference<UIView>(newSuperview);
        this.setNeedsLayout();
        this.didMoveToSuperview();
        if (newSuperview == null) {
            this._setWindow(null);
            return;
        }
        newSuperview._setAutoresizingFlagsDirty();
        if (newSuperview.window() != null) {
            this._setWindow(newSuperview._window);
        }
        if (newSuperview instanceof UIWindow) {
            UIWindow window = (UIWindow)newSuperview;
            this._setWindow(new WeakReference<UIWindow>(window));
        }
    }

    private void _setWindow(WeakReference<UIWindow> newValue) {
        if (this._window == newValue) {
            return;
        }
        UIWindow oldWindow = this.window();
        UIWindow newWindow = null;
        if (newValue != null) {
            newWindow = (UIWindow)newValue.get();
        }
        this.willMoveToWindow(newWindow);
        this._window = newValue;
        this._subviews.forEach(subview -> subview._setWindow(newValue));
        this.didMoveToWindow();
        if (oldWindow != null && newWindow == null) {
            oldWindow._didRemoveFromWindow(this);
        }
    }

    private CGRect _remakeFrame() {
        CGRect rect = this._bounds.copy();
        if (this._transform != CGAffineTransform.IDENTITY) {
            rect.apply(this._transform);
        }
        rect.x = this._center.x - rect.width * 0.5f;
        rect.y = this._center.y - rect.height * 0.5f;
        return rect;
    }

    private CGAffineTransform _remakeInvertedTransform() {
        if (this._transform.isIdentity()) {
            return CGAffineTransform.IDENTITY;
        }
        return this._transform.inverted();
    }

    public void _setSize(CGSize size) {
        CGPoint center = this.center();
        CGRect rect = this.bounds();
        float dx = (size.width - rect.width) / 2.0f;
        float dy = (size.height - rect.height) / 2.0f;
        this.setBounds(new CGRect(rect.x, rect.y, size.width, size.height));
        this.setCenter(new CGPoint(center.x + dx, center.y + dy));
    }

    @Override
    public CGAffineTransform _invertedTransform() {
        if (this._invertedTransform == null) {
            this._invertedTransform = this._remakeInvertedTransform();
        }
        return this._invertedTransform;
    }

    public Iterable<UIView> _invertedSubviews() {
        List<UIView> subviews = this.subviews();
        ReversedIteratorImpl<UIView> iterator = new ReversedIteratorImpl<UIView>(subviews.listIterator(subviews.size()));
        return () -> iterator;
    }

    protected static class Flags {
        public boolean isHovered = false;
        public boolean isFocused = false;
        public boolean isUserInteractionEnabled = true;
        public boolean isDirty = false;
        public boolean needsLayout = false;
        public boolean needsAutoresizing = false;

        protected Flags() {
        }
    }

    public static class AutoresizingMask {
        public static final int flexibleLeftMargin = 1;
        public static final int flexibleWidth = 2;
        public static final int flexibleRightMargin = 4;
        public static final int flexibleTopMargin = 8;
        public static final int flexibleHeight = 16;
        public static final int flexibleBottomMargin = 32;
    }
}

