/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import moe.plushie.armourers_workshop.builder.data.palette.Palette;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PaletteBox
extends UIControl {
    private int row = 4;
    private int column = 8;
    private float cellWidth = 0.0f;
    private float cellHeight = 0.0f;
    private int selectedIndex = 0;
    private Palette palette;
    private CGRect cachedBounds = CGRect.ZERO;
    private final UIImage backgroundImage = ModTextures.defaultButtonImage().imageAtIndex(4);

    public PaletteBox(CGRect frame) {
        super(frame);
    }

    @Override
    public void mouseDown(UIEvent event) {
        this.updateSelectedIndex(event.locationInView(this));
        super.mouseDown(event);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        context.drawImage(this.backgroundImage, this.bounds());
        if (this.palette == null) {
            return;
        }
        for (int j = 0; j < this.row; ++j) {
            for (int i = 0; i < this.column; ++i) {
                int index = j * this.column + i;
                CGRect rect = new CGRect((float)i * this.cellWidth + 1.0f, (float)j * this.cellHeight + 1.0f, this.cellWidth, this.cellHeight);
                context.fillRect(rect, this.palette.getColor(index));
            }
        }
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect rect = this.bounds();
        if (this.cachedBounds.equals(rect)) {
            return;
        }
        this.cellWidth = (rect.width - 2.0f) / (float)this.column;
        this.cellHeight = (rect.height - 2.0f) / (float)this.row;
        this.cachedBounds = rect;
    }

    public int row() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
        this.setNeedsLayout();
    }

    public int column() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
        this.setNeedsLayout();
    }

    public Palette palette() {
        return this.palette;
    }

    public void setPalette(Palette palette) {
        this.palette = palette;
    }

    public int selectedIndex() {
        return this.selectedIndex;
    }

    private void updateSelectedIndex(CGPoint point) {
        if (this.cellWidth == 0.0f || this.cellHeight == 0.0f) {
            return;
        }
        CGRect rect = this.bounds();
        int i = (int)((point.x - rect.x - 1.0f) / this.cellWidth);
        int j = (int)((point.y - rect.y - 1.0f) / this.cellHeight);
        if (i < 0 || j < 0 || i >= this.column || j >= this.row) {
            return;
        }
        this.selectedIndex = j * this.column + i;
    }
}

