/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.common.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.builder.blockentity.BoundingBoxBlockEntity;
import moe.plushie.armourers_workshop.builder.blockentity.SkinCubeBlockEntity;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.ExtendedFaceRenderer;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2586;

@Environment(value=EnvType.CLIENT)
public class SkinCubeBlockRenderer<T extends class_2586>
extends AbstractBlockEntityRenderer<T> {
    private static float markerAlpha = 0.0f;
    private static long lastWorldTimeUpdate;

    public SkinCubeBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public static void updateAlpha(class_2586 blockEntity) {
        class_1937 level = blockEntity.method_10997();
        if (level == null || lastWorldTimeUpdate == level.method_8510()) {
            return;
        }
        lastWorldTimeUpdate = level.method_8510();
        if (SkinCubeBlockRenderer.isPlayerHoldingPaintingTool()) {
            if ((markerAlpha += 0.25f) > 1.0f) {
                markerAlpha = 1.0f;
            }
        } else if ((markerAlpha -= 0.25f) < 0.0f) {
            markerAlpha = 0.0f;
        }
    }

    private static boolean isPlayerHoldingPaintingTool() {
        class_1657 player = EnvironmentManager.getPlayer();
        if (player == null) {
            return false;
        }
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7909() instanceof IBlockPaintViewer) {
            return true;
        }
        if (itemStack.method_31574((class_1792)ModItems.COLOR_PICKER.get())) {
            return true;
        }
        return itemStack.method_31574((class_1792)ModItems.SOAP.get());
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        SkinCubeBlockRenderer.updateAlpha(entity);
        if (!(markerAlpha > 0.0f)) {
            return;
        }
        int alpha = (int)(markerAlpha * 255.0f);
        IVertexConsumer builder = bufferSource.getBuffer(SkinRenderType.IMAGE_MARKER);
        for (OpenDirection direction : OpenDirection.values()) {
            if (!((IBlockPaintable)entity).shouldChangeColor(direction) || !((IBlockPaintable)entity).hasColor(direction)) continue;
            SkinPaintColor paintColor = ((IBlockPaintable)entity).getColor(direction);
            ExtendedFaceRenderer.renderMarker(0, 0, 0, direction, paintColor, alpha, light, overlay, poseStack, builder);
        }
    }

    @Override
    public boolean shouldRender(T entity) {
        if (entity instanceof SkinCubeBlockEntity) {
            SkinCubeBlockEntity entity1 = (SkinCubeBlockEntity)entity;
            return entity1.isCustomRenderer();
        }
        if (entity instanceof BoundingBoxBlockEntity) {
            BoundingBoxBlockEntity entity1 = (BoundingBoxBlockEntity)entity;
            return entity1.isCustomRenderer();
        }
        return false;
    }
}

