/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.builder.client.gui.PaletteToolWindow;
import moe.plushie.armourers_workshop.builder.item.AbstractColoredToolItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IPaintProvider;
import moe.plushie.armourers_workshop.core.data.paint.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutorIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3414;

public class PaintbrushItem
extends AbstractColoredToolItem
implements IItemTintColorProvider,
IItemPropertiesProvider,
IItemPaintable,
IBlockPaintViewer,
IPaintToolPicker {
    public PaintbrushItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1269 resultType = this.usePickTool(context);
        if (resultType.method_23665()) {
            return resultType;
        }
        return super.method_7884(context);
    }

    @Override
    public class_1269 usePickTool(class_1937 level, class_2338 pos, OpenDirection dir, class_2586 blockEntity, class_1838 context) {
        if (blockEntity instanceof IPaintProvider) {
            IPaintProvider provider = (IPaintProvider)blockEntity;
            this.setItemColor(context.method_8041(), provider.color());
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.FULL_BLOCK_MODE);
        builder.accept(PaintingToolOptions.CHANGE_PAINT_COLOR);
        builder.accept(PaintingToolOptions.CHANGE_PAINT_TYPE);
    }

    @Override
    public IPaintToolAction createPaintToolAction(class_1838 context) {
        class_1799 itemStack = context.method_8041();
        SkinPaintColor paintColor = this.getItemColor(itemStack, SkinPaintColor.WHITE);
        Boolean usePaintColor = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_PAINT_COLOR);
        Boolean usePaintType = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_PAINT_TYPE);
        return new CubePaintingEvent.SetAction(paintColor, usePaintColor, usePaintType);
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("small"), (itemStack, level, entity, id) -> ToolAPI.get(itemStack, PaintingToolOptions.FULL_BLOCK_MODE) != false ? 0.0f : 1.0f);
    }

    @Override
    public void appendColorHoverText(class_1799 itemStack, List<class_2561> tooltips) {
        SkinPaintColor paintColor = this.getItemColor(itemStack, SkinPaintColor.WHITE);
        tooltips.addAll(ColorUtils.getColorTooltips(paintColor, true));
    }

    @Override
    public boolean openContainer(class_1937 level, class_1657 player, class_1268 hand, class_1799 itemStack) {
        if (level.method_8608() && EnvironmentExecutorIO.hasControlDown()) {
            this.openPaletteGUI(level, player, hand, itemStack);
            return true;
        }
        return super.openContainer(level, player, hand, itemStack);
    }

    @Environment(value=EnvType.CLIENT)
    public void openPaletteGUI(class_1937 level, class_1657 player, class_1268 hand, class_1799 itemStack) {
        PaletteToolWindow window = new PaletteToolWindow(itemStack.method_7964(), itemStack, hand);
        class_310.method_1551().method_1507(window.asScreen());
    }

    @Override
    public void setItemColor(class_1799 itemStack, SkinPaintColor paintColor) {
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), paintColor);
    }

    @Override
    public SkinPaintColor getItemColor(class_1799 itemStack) {
        return (SkinPaintColor)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
    }

    @Override
    public int getTintColor(class_1799 itemStack, int index) {
        if (index == 1) {
            return ColorUtils.getDisplayRGB(itemStack);
        }
        return -1;
    }

    @Override
    public IRegistryHolder<class_3414> getItemSoundEvent(class_1838 context) {
        return ModSounds.PAINT;
    }

    public boolean method_7886(class_1799 itemStack) {
        SkinPaintColor paintColor = this.getItemColor(itemStack, SkinPaintColor.WHITE);
        return paintColor.paintType() != SkinPaintTypes.NORMAL;
    }
}

