/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import moe.plushie.armourers_workshop.api.action.IUserAction;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.UndoStack;
import moe.plushie.armourers_workshop.builder.data.undo.action.ActionRuntimeException;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class UndoActionPacket
extends CustomPacket {
    private final boolean isRedo;

    public UndoActionPacket(IFriendlyByteBuf buffer) {
        this.isRedo = buffer.readBoolean();
    }

    public UndoActionPacket(boolean isRedo) {
        this.isRedo = isRedo;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isRedo);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, class_3222 player) {
        try {
            class_5250 message;
            UndoStack stack = UndoManager.of(player.method_5667());
            if (this.isRedo) {
                if (!ModPermissions.REDO.accept((class_1657)player)) {
                    return;
                }
                IUserAction command = stack.redo();
                message = class_2561.method_43469((String)"chat.armourers_workshop.undo.redoing", (Object[])new Object[]{command.name()});
            } else {
                if (!ModPermissions.UNDO.accept((class_1657)player)) {
                    return;
                }
                IUserAction command = stack.undo();
                message = class_2561.method_43469((String)"chat.armourers_workshop.undo.undoing", (Object[])new Object[]{command.name()});
            }
            player.method_43496((class_2561)message);
        }
        catch (ActionRuntimeException exception) {
            player.method_43496(exception.getComponent());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

