/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IRenderTypeBuilder;
import moe.plushie.armourers_workshop.api.client.IVertexFormat;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerKey;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerProvider;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderTypeImpl;
import moe.plushie.armourers_workshop.compatibility.client.AbstractVertexFormat;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexFormat;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import net.minecraft.class_1921;

public class AbstractRenderType
extends SkinRenderType
implements IAssociatedContainerProvider {
    private boolean isEmissive = false;
    private boolean isOutline = false;
    private int ordinal = 0;
    private IRenderType.Target target = IRenderType.Target.MAIN;
    private IRenderType.Transparency transparency = IRenderType.Transparency.NONE;
    private final IVertexFormat.Mode mode;
    private final IVertexFormat format;
    private final class_1921 impl;
    private final DataContainer storage = new DataContainer();
    private final Optional<IRenderType> outline;

    private AbstractRenderType(class_1921 renderType) {
        this.impl = renderType;
        this.mode = AbstractVertexFormat.of(renderType.method_23033());
        this.format = AbstractVertexFormat.of(renderType.method_23031());
        this.outline = renderType.method_23289().map(AbstractRenderType::of);
        this.isOutline = renderType.method_24295();
    }

    public static AbstractRenderType of(class_1921 renderType) {
        return DataContainer.of(renderType, AbstractRenderType::new);
    }

    public static IRenderTypeBuilder builder(SkinVertexFormat format) {
        return AbstractRenderTypeImpl.builder(format);
    }

    public void apply(ArrayList<Consumer<AbstractRenderType>> updater) {
        updater.forEach((Consumer<Consumer<AbstractRenderType>>)((Consumer<Consumer>)it -> it.accept(this)));
        this.outline.ifPresent(type -> {
            ((AbstractRenderType)type).ordinal = this.ordinal;
        });
    }

    @Override
    public <T> T getAssociatedObject(IAssociatedContainerKey<T> key) {
        return this.storage.getAssociatedObject(key);
    }

    @Override
    public <T> void setAssociatedObject(IAssociatedContainerKey<T> key, T value) {
        this.storage.setAssociatedObject(key, value);
    }

    @Override
    public boolean isEmissive() {
        return this.isEmissive;
    }

    @Override
    public boolean isTranslucent() {
        return this.transparency != IRenderType.Transparency.NONE;
    }

    @Override
    public boolean isOutline() {
        return this.isOutline;
    }

    @Override
    public int bufferSize() {
        return this.impl.method_22722();
    }

    @Override
    public int ordinal() {
        return this.ordinal;
    }

    @Override
    public IVertexFormat.Mode mode() {
        return this.mode;
    }

    @Override
    public IVertexFormat format() {
        return this.format;
    }

    @Override
    public Optional<IRenderType> outline() {
        return this.outline;
    }

    @Override
    public class_1921 get() {
        return this.impl;
    }

    public String toString() {
        return this.impl.toString();
    }

    public static abstract class Builder
    implements IRenderTypeBuilder {
        protected final ArrayList<Consumer<AbstractRenderType>> updater = new ArrayList();

        public IRenderTypeBuilder format(SkinVertexFormat format) {
            return this;
        }

        @Override
        public IRenderTypeBuilder emissive() {
            this.updater.add(t -> {
                t.isEmissive = true;
            });
            return this;
        }

        @Override
        public IRenderTypeBuilder target(IRenderType.Target target) {
            this.updater.add(t -> {
                t.target = target;
            });
            return this;
        }

        @Override
        public IRenderTypeBuilder transparency(IRenderType.Transparency transparency) {
            this.updater.add(t -> {
                t.transparency = transparency;
            });
            return this;
        }

        @Override
        public IRenderTypeBuilder ordinal(int ordinal) {
            this.updater.add(t -> {
                t.ordinal = ordinal;
            });
            return this;
        }
    }
}

