/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.fabric;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IPacketDistributor;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AbstractFabricNetwork {

    public static enum NetworkDirection {
        PLAY_TO_SERVER(() -> ClientPlayNetworking::createC2SPacket),
        PLAY_TO_CLIENT(() -> ServerPlayNetworking::createS2CPacket);

        final Supplier<BiFunction<class_2960, class_2540, class_2596<?>>> builder;

        private NetworkDirection(Supplier<BiFunction<class_2960, class_2540, class_2596<?>>> builder) {
            this.builder = builder;
        }

        public class_2596<?> buildPacket(IFriendlyByteBuf buf, IResourceLocation channelName) {
            return this.builder.get().apply(channelName.toLocation(), (class_2540)buf.asByteBuf());
        }
    }

    public static class Distributors
    implements NetworkManager.Distributors {
        @Override
        public IPacketDistributor trackingChunk(Supplier<class_2818> supplier) {
            class_2818 chunk = supplier.get();
            class_3218 serverLevel = (class_3218)chunk.method_12200();
            Collection players = PlayerLookup.tracking((class_3218)serverLevel, (class_1923)chunk.method_12004());
            return new Distributor(NetworkDirection.PLAY_TO_CLIENT, this.dispatch(players), null);
        }

        @Override
        public IPacketDistributor trackingEntityAndSelf(Supplier<class_1297> supplier) {
            class_1297 entity = supplier.get();
            ArrayList<class_3222> players = PlayerLookup.tracking((class_1297)entity);
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                ArrayList<class_3222> trackingAndSelf = new ArrayList<class_3222>(players);
                trackingAndSelf.add(player);
                players = trackingAndSelf;
            }
            return new Distributor(NetworkDirection.PLAY_TO_CLIENT, this.dispatch((Collection<class_3222>)players), null);
        }

        @Override
        public IPacketDistributor player(Supplier<class_3222> supplier) {
            class_3222 player = supplier.get();
            return new Distributor(NetworkDirection.PLAY_TO_CLIENT, this.dispatch(Collections.singleton(player)), null);
        }

        @Override
        public IPacketDistributor allPlayers() {
            return new Distributor(NetworkDirection.PLAY_TO_CLIENT, this.dispatch(PlayerLookup.all((MinecraftServer)EnvironmentManager.getServer())), null);
        }

        @Override
        public IPacketDistributor server() {
            return new Distributor(NetworkDirection.PLAY_TO_SERVER, arg_0 -> ((PacketSender)ClientPlayNetworking.getSender()).sendPacket(arg_0), null);
        }

        private Consumer<class_2596<?>> dispatch(Collection<class_3222> players) {
            return packet -> players.forEach(player -> player.field_13987.method_14364(packet));
        }
    }

    public static class Distributor
    implements IPacketDistributor {
        private final NetworkDirection direction;
        private final Consumer<class_2596<?>> target;
        private final class_2596<?> packet;

        Distributor(NetworkDirection direction, Consumer<class_2596<?>> target, class_2596<?> packet) {
            this.direction = direction;
            this.target = target;
            this.packet = packet;
        }

        @Override
        public IPacketDistributor add(IResourceLocation channel, IFriendlyByteBuf buf) {
            class_2596<?> packet1 = this.direction.buildPacket(buf, channel);
            return new Distributor(this.direction, this.target, packet1);
        }

        @Override
        public void execute() {
            if (this.packet != null) {
                this.target.accept(this.packet);
            }
        }

        @Override
        public boolean isClientbound() {
            return this.direction == NetworkDirection.PLAY_TO_CLIENT;
        }
    }

    public static class Dispatcher
    extends NetworkManager.Dispatcher {
        public Dispatcher(IResourceLocation channelName, String channelVersion) {
            super(channelName, channelVersion);
        }

        @Override
        public void register() {
            ServerLoginConnectionEvents.QUERY_START.register(this::startServerHandshake);
            ServerLoginNetworking.registerGlobalReceiver((class_2960)this.channelName.toLocation(), this::onServerHandshake);
            ServerPlayNetworking.registerGlobalReceiver((class_2960)this.channelName.toLocation(), this::onServerEvent);
            EnvironmentExecutor.runOn(EnvironmentType.CLIENT, () -> () -> {
                ClientLoginNetworking.registerGlobalReceiver((class_2960)this.channelName.toLocation(), this::onClientHandshake);
                ClientPlayNetworking.registerGlobalReceiver((class_2960)this.channelName.toLocation(), this::onClientEvent);
            });
        }

        public void startServerHandshake(Object handler, MinecraftServer server, PacketSender sender, ServerLoginNetworking.LoginSynchronizer synchronizer) {
            if (ModConfig.Common.enableProtocolCheck) {
                sender.sendPacket(this.channelName.toLocation(), PacketByteBufs.empty());
            }
        }

        public void onServerHandshake(MinecraftServer server, class_3248 handler, boolean understood, class_2540 buf, ServerLoginNetworking.LoginSynchronizer synchronizer, PacketSender responseSender) {
            String version;
            if (!ModConfig.Common.enableProtocolCheck) {
                return;
            }
            if (understood && (version = buf.method_19772()).equals(this.channelVersion)) {
                return;
            }
            handler.method_14380((class_2561)class_2561.method_43470((String)"Please install correct Armourers Workshop to play on this server!"));
        }

        @Environment(value=EnvType.CLIENT)
        public CompletableFuture<@Nullable class_2540> onClientHandshake(class_310 client, Object handler, class_2540 buf, Consumer<GenericFutureListener<? extends Future<? super Void>>> listenerAdder) {
            class_2540 responseBuffer = new class_2540(Unpooled.buffer());
            responseBuffer.method_10814(this.channelVersion);
            return CompletableFuture.completedFuture(responseBuffer);
        }

        public void onServerEvent(MinecraftServer server, class_3222 player, Object handler, class_2540 buf, PacketSender responseSender) {
            IServerPacketHandler packetHandler = arg_0 -> ((MinecraftServer)server).execute(arg_0);
            this.didReceivePacket(packetHandler, IFriendlyByteBuf.wrap((ByteBuf)buf), player);
        }

        @Environment(value=EnvType.CLIENT)
        public void onClientEvent(class_310 client, Object handler, class_2540 buf, PacketSender responseSender) {
            IClientPacketHandler packetHandler = arg_0 -> ((class_310)client).execute(arg_0);
            this.didReceivePacket(packetHandler, IFriendlyByteBuf.wrap((ByteBuf)buf), null);
        }
    }
}

