/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import com.apple.library.uikit.UIWindowManager;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreen;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ContainerMenuScreen<M extends class_1703, W extends UIWindow>
extends AbstractMenuScreen<M> {
    private final W window;
    private final MenuWindow<?> menuWindow;
    private final UIWindowManager manager;

    public ContainerMenuScreen(W window, M menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title);
        this.window = window;
        this.menuWindow = Objects.safeCast(window, MenuWindow.class);
        this.manager = new UIWindowManager();
        this.manager.addWindow((UIWindow)window);
        this.manager.init();
    }

    public void method_25426() {
        CGSize screenSize = this.screenSize();
        this.manager.layout(screenSize.width, screenSize.height);
        CGRect rect = ((UIView)this.window).bounds();
        this.setContentSize(new CGSize(rect.width, rect.height));
        super.method_25426();
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
    }

    public void method_37432() {
        super.method_37432();
        this.menuWindow.screenWillTick();
    }

    public void method_25432() {
        super.method_25432();
        this.manager.deinit();
    }

    @Override
    public void render(CGGraphicsContext context, int mouseX, int mouseY, float partialTicks) {
        this.manager.tick();
        this.manager.render(context, this::_render, this::_renderBackground, this::_renderTooltip);
    }

    @Override
    public void renderLabels(CGGraphicsContext context, int mouseX, int mouseY) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.manager.mouseDown(mouseX, mouseY, button, this::_mouseClicked);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.manager.mouseUp(mouseX, mouseY, button, this::_mouseReleased);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.manager.mouseWheel(mouseX, mouseY, new CGPoint(deltaX, deltaY), this::_mouseScrolled);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.manager.mouseMoved(mouseX, mouseY, 0, this::_mouseMoved);
    }

    public boolean method_25404(int key, int i, int j) {
        return this.manager.keyDown(key, i, j, this::_keyPressed);
    }

    public boolean method_16803(int key, int i, int j) {
        return this.manager.keyUp(key, i, j, this::_keyReleased);
    }

    public boolean method_25400(char ch, int i) {
        return this.manager.charTyped(ch, i, 0, this::_charTyped);
    }

    public boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        return !this.manager.mouseIsInside(mouseX, mouseY, button);
    }

    public void method_2383(class_1735 slot, int slotIndex, int j, class_1713 clickType) {
        super.method_2383(slot, slotIndex, j, clickType);
        this.menuWindow.menuDidChange();
    }

    @Override
    public boolean changeFocus(boolean bl) {
        return this.manager.changeKeyView(bl);
    }

    public boolean shouldRenderExtendScreen() {
        if (this.menuWindow != null) {
            return this.menuWindow.shouldRenderExtendScreen();
        }
        return false;
    }

    protected void _render(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        super.render(context, mouseX, mouseY, partialTicks);
    }

    protected void _renderTooltip(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        context.saveGraphicsState();
        context.translateCTM(0.0f, 0.0f, 400.0f);
        this.renderTooltip(context, mouseX, mouseY);
        context.restoreGraphicsState();
    }

    protected void _renderBackground(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        if (this.menuWindow != null && this.menuWindow.shouldRenderBackground()) {
            this.renderBackground(context);
        }
    }

    protected boolean _charTyped(int key, int i, int j) {
        super.method_25400((char)key, i);
        return true;
    }

    protected boolean _keyPressed(int key, int i, int j) {
        if (this.manager.isTextEditing() && !this._editingPassKey((char)key)) {
            return false;
        }
        return super.method_25404(key, i, j);
    }

    protected boolean _keyReleased(int key, int i, int j) {
        return super.method_16803(key, i, j);
    }

    protected boolean _mouseClicked(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    protected boolean _mouseMoved(double mouseX, double mouseY, int button) {
        super.method_16014(mouseX, mouseY);
        return true;
    }

    protected boolean _mouseScrolled(double mouseX, double mouseY, CGPoint delta) {
        return super.mouseScrolled(mouseX, mouseY, delta.x(), delta.y());
    }

    protected boolean _mouseReleased(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    protected boolean _editingPassKey(int key) {
        return switch (key) {
            case 256 -> true;
            case 258 -> true;
            default -> false;
        };
    }
}

