/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IVertexFormat;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentBufferCompiler;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentRenderingContext;
import moe.plushie.armourers_workshop.core.client.other.VertexArrayObject;
import moe.plushie.armourers_workshop.core.client.other.VertexBufferObject;
import moe.plushie.armourers_workshop.core.client.other.VertexIndexObject;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.data.cache.ObjectPool;
import moe.plushie.armourers_workshop.core.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.utils.ReferenceCounted;

public class ConcurrentRenderingPipeline {
    private final ArrayList<Group> passGroups = new ArrayList();

    public void add(ConcurrentBufferCompiler.Group group, ConcurrentRenderingContext context) {
        Group pass = Group.POOL.get();
        IPoseStack poseStack = context.poseStack();
        IPoseStack modelViewStack = context.modelViewStack();
        OpenPoseStack.Pose last = pass.poseStack.last();
        OpenMatrix4f lastPose = last.pose();
        OpenMatrix3f lastNormal = last.normal();
        lastPose.set(modelViewStack.last().pose());
        lastPose.multiply(poseStack.last().pose());
        lastNormal.set(modelViewStack.last().normal());
        lastNormal.multiply(poseStack.last().normal());
        last.setProperties(poseStack.last().properties());
        this.passGroups.add(pass.fill(group, context));
    }

    public void commit(Consumer<ShaderVertexObject> consumer) {
        for (Group pass : this.passGroups) {
            pass.forEach(consumer);
        }
        this.passGroups.clear();
    }

    private static class Group
    extends ReferenceCounted {
        private static final ObjectPool<Group> POOL = ObjectPool.create(Group::new);
        private final OpenPoseStack poseStack = new OpenPoseStack();
        private final ArrayList<Pass> pendingQueue = new ArrayList();
        private int usedCount = 0;
        private int totalCount = 0;
        private ConcurrentBufferCompiler.Group compiledGroup;

        private Group() {
        }

        public void forEach(Consumer<ShaderVertexObject> consumer) {
            for (int i = 0; i < this.usedCount; ++i) {
                Pass pass = this.pendingQueue.get(i);
                consumer.accept(pass);
            }
        }

        public Group fill(ConcurrentBufferCompiler.Group group, ConcurrentRenderingContext context) {
            this.usedCount = 0;
            this.compiledGroup = group;
            for (ConcurrentBufferCompiler.Pass mergedTask : group.passes()) {
                if (!context.shouldRenderOutline() && mergedTask.isOutline) continue;
                this.poll().fill(mergedTask, this.poseStack, context);
            }
            return this;
        }

        @Override
        protected void init() {
            if (this.compiledGroup != null) {
                this.compiledGroup.retain();
            }
        }

        @Override
        protected void dispose() {
            if (this.compiledGroup != null) {
                this.compiledGroup.release();
                this.compiledGroup = null;
            }
        }

        private Pass poll() {
            if (this.usedCount < this.totalCount) {
                return this.pendingQueue.get(this.usedCount++);
            }
            Pass pass = new Pass(this);
            this.pendingQueue.add(pass);
            ++this.totalCount;
            ++this.usedCount;
            return pass;
        }
    }

    private static class Pass
    implements ShaderVertexObject {
        private int overlay;
        private int lightmap;
        private int outlineColor;
        private float polygonOffset;
        private OpenPoseStack poseStack;
        private ConcurrentBufferCompiler.Pass compiledTask;
        private final Group group;

        public Pass(Group group) {
            this.group = group;
        }

        public void fill(ConcurrentBufferCompiler.Pass compiledTask, OpenPoseStack poseStack, ConcurrentRenderingContext context) {
            this.compiledTask = compiledTask;
            this.poseStack = poseStack;
            this.overlay = context.overlay();
            this.lightmap = context.lightmap();
            this.outlineColor = context.outlineColor();
            this.polygonOffset = compiledTask.polygonOffset + context.renderPriority();
            this.retain();
        }

        @Override
        public IRenderType type() {
            return this.compiledTask.renderType;
        }

        @Override
        public int offset() {
            return this.compiledTask.vertexOffset;
        }

        @Override
        public int total() {
            return this.compiledTask.vertexCount;
        }

        @Override
        public VertexArrayObject arrayObject() {
            return this.compiledTask.arrayObject;
        }

        @Override
        public VertexIndexObject indexObject() {
            return this.compiledTask.indexObject;
        }

        @Override
        public VertexBufferObject bufferObject() {
            return this.compiledTask.bufferObject;
        }

        @Override
        public float polygonOffset() {
            return this.polygonOffset;
        }

        @Override
        public OpenPoseStack poseStack() {
            return this.poseStack;
        }

        @Override
        public IVertexFormat format() {
            if (this.compiledTask.format != null) {
                return this.compiledTask.format;
            }
            return this.compiledTask.renderType.format();
        }

        @Override
        public int overlay() {
            return this.overlay;
        }

        @Override
        public int lightmap() {
            return this.lightmap;
        }

        @Override
        public int outlineColor() {
            return this.outlineColor;
        }

        @Override
        public boolean isEmissive() {
            return this.compiledTask.isEmissive;
        }

        @Override
        public boolean isTranslucent() {
            return this.compiledTask.isTranslucent;
        }

        @Override
        public boolean isOutline() {
            return this.compiledTask.isOutline;
        }

        public void retain() {
            this.group.retain();
        }

        @Override
        public void release() {
            this.group.release();
        }
    }
}

