/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenNativeImage;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class SkinDynamicTexture
extends class_1043 {
    private final class_1060 textureManager = class_310.method_1551().method_1531();
    private SkinPaintData paintData;
    private OpenNativeImage downloadedImage;
    private OpenResourceLocation refer;
    private class_1044 referTexture;
    private boolean needsUpdate = true;

    public SkinDynamicTexture() {
        super(64, 64, true);
    }

    public OpenResourceLocation refer() {
        return this.refer;
    }

    public void setRefer(OpenResourceLocation refer) {
        if (!Objects.equals(this.refer, refer)) {
            this.refer = refer;
            this.referTexture = Objects.flatMap(refer, it -> this.textureManager.method_4619(it.toLocation()));
            this.downloadedImage = null;
            this.setNeedsUpdate();
        }
    }

    public SkinPaintData paintData() {
        return this.paintData;
    }

    public void setPaintData(SkinPaintData paintData) {
        if (this.paintData != paintData) {
            this.paintData = paintData;
            this.setNeedsUpdate();
        }
    }

    public void method_4524() {
        OpenNativeImage downloadedImage = this.downloadedImage();
        OpenNativeImage mergedImage = OpenNativeImage.of(this.method_4525());
        if (mergedImage == null || downloadedImage == null) {
            return;
        }
        mergedImage.copyFrom(downloadedImage);
        if (this.paintData != null) {
            this.applyPaintColor(mergedImage);
        }
        super.method_4524();
    }

    private void setNeedsUpdate() {
        this.needsUpdate = true;
        RenderSystem.recordRenderCall(() -> {
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.method_4524();
            }
        });
    }

    private void applyPaintColor(OpenNativeImage mergedImage) {
        for (int iy = 0; iy < this.paintData.height(); ++iy) {
            for (int ix = 0; ix < this.paintData.width(); ++ix) {
                int color = this.paintData.getColor(ix, iy);
                if (!SkinPaintColor.isOpaque(color)) continue;
                mergedImage.setPixel(ix, iy, color);
            }
        }
    }

    private OpenNativeImage downloadedImage() {
        if (this.downloadedImage != null) {
            return this.downloadedImage;
        }
        if (this.referTexture != null) {
            GL11.glBindTexture((int)3553, (int)this.referTexture.method_4624());
            this.downloadedImage = OpenNativeImage.of(0, 64, 64);
        }
        return this.downloadedImage;
    }
}

