/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.google.common.collect.Range;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanUse;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1685;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class SkinRenderHelper {
    public static int getRenderCount(BakedSkin bakedSkin) {
        int count = 0;
        for (BakedSkinPart part : bakedSkin.parts()) {
            if (!part.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public static void apply(@Nullable class_1297 entity, BakedSkin bakedSkin, BakedArmature bakedArmature, SkinItemSource itemSource) {
        for (BakedSkinPart part : bakedSkin.parts()) {
            boolean shouldRender = false;
            if (bakedArmature != null && bakedArmature.transformByPart(part) != null) {
                shouldRender = true;
            }
            if (shouldRender) {
                shouldRender = SkinRenderHelper.shouldRenderPart(entity, part, bakedSkin, itemSource);
            }
            part.setShouldRender(shouldRender);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldRenderPart(@Nullable class_1297 entity, BakedSkinPart bakedPart, BakedSkin bakedSkin, SkinItemSource itemSource) {
        SkinPartType partType = bakedPart.type();
        if (partType == SkinPartTypes.ITEM_FISHING_HOOK) {
            return SkinRenderHelper.isHookEntity(entity);
        }
        if (partType == SkinPartTypes.ITEM_FISHING_ROD1) {
            if (!(entity instanceof class_1657)) return false;
            class_1657 player = (class_1657)entity;
            if (player.field_7513 == null) return false;
            return true;
        }
        if (partType == SkinPartTypes.ITEM_FISHING_ROD) {
            if (SkinRenderHelper.isHookEntity(entity)) {
                return false;
            }
            if (!(entity instanceof class_1657)) return true;
            class_1657 player = (class_1657)entity;
            if (player.field_7513 == null) return true;
            return false;
        }
        if (partType == SkinPartTypes.ITEM_ARROW) {
            if (SkinRenderHelper.isArrowEntity(entity)) {
                return true;
            }
            if (itemSource.displayContext() != OpenItemDisplayContext.NONE) return false;
            if (bakedPart.children().size() != 1) return false;
            return true;
        }
        if (SkinRenderHelper.isArrowEntity(entity)) {
            return false;
        }
        if (SkinRenderHelper.isHookEntity(entity)) {
            return false;
        }
        if (!(partType instanceof ICanUse)) return true;
        ICanUse canUse = (ICanUse)((Object)partType);
        if (!(entity instanceof class_1309)) return true;
        class_1309 livingEntity = (class_1309)entity;
        int useTick = SkinRenderHelper.getUseTick(livingEntity, itemSource.item());
        Range<Integer> useRange = canUse.useRange();
        Range<Integer> tickRange = bakedSkin.useTickRange();
        return useRange.contains((Comparable)Integer.valueOf(OpenMath.clamp(useTick, (Integer)tickRange.lowerEndpoint(), (Integer)tickRange.upperEndpoint())));
    }

    private static boolean isHookEntity(@Nullable class_1297 entity) {
        return entity instanceof class_1536;
    }

    private static boolean isArrowEntity(@Nullable class_1297 entity) {
        if (entity instanceof class_1685) {
            return false;
        }
        return entity instanceof class_1665;
    }

    public static int getUseTick(class_1309 entity, class_1799 itemStack) {
        if (entity.method_6030() == itemStack) {
            return entity.method_6048();
        }
        if (class_1764.method_7781((class_1799)itemStack)) {
            return 100;
        }
        return 0;
    }
}

