/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.core.math.IVector3f;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class OpenRectangle3f
implements IRectangle3f {
    public static final int BYTES = 24;
    public static final OpenRectangle3f ZERO = new OpenRectangle3f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final IDataCodec<OpenRectangle3f> CODEC = IDataCodec.FLOAT.listOf().xmap(OpenRectangle3f::new, OpenRectangle3f::toList);
    public float x;
    public float y;
    public float z;
    public float width;
    public float height;
    public float depth;

    public OpenRectangle3f(IRectangle3i rect) {
        this(rect.x(), rect.y(), rect.z(), rect.width(), rect.height(), rect.depth());
    }

    public OpenRectangle3f(IRectangle3f rect) {
        this(rect.x(), rect.y(), rect.z(), rect.width(), rect.height(), rect.depth());
    }

    public OpenRectangle3f(float x, float y, float z, float width, float height, float depth) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public OpenRectangle3f(double x, double y, double z, double width, double height, double depth) {
        this((float)x, (float)y, (float)z, (float)width, (float)height, (float)depth);
    }

    public OpenRectangle3f(List<Float> list) {
        this(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue(), list.get(3).floatValue(), list.get(4).floatValue(), list.get(5).floatValue());
    }

    public void union(IRectangle3f rect) {
        float x1 = Math.min(this.minX(), rect.minX());
        float y1 = Math.min(this.minY(), rect.minY());
        float z1 = Math.min(this.minZ(), rect.minZ());
        float x2 = Math.max(this.maxX(), rect.maxX());
        float y2 = Math.max(this.maxY(), rect.maxY());
        float z2 = Math.max(this.maxZ(), rect.maxZ());
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.width = x2 - x1;
        this.height = y2 - y1;
        this.depth = z2 - z1;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setDepth(float depth) {
        this.depth = depth;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public float z() {
        return this.z;
    }

    @Override
    public float width() {
        return this.width;
    }

    @Override
    public float height() {
        return this.height;
    }

    @Override
    public float depth() {
        return this.depth;
    }

    @Override
    public float minX() {
        return this.x;
    }

    @Override
    public float minY() {
        return this.y;
    }

    @Override
    public float minZ() {
        return this.z;
    }

    @Override
    public float midX() {
        return this.x + this.width / 2.0f;
    }

    @Override
    public float midY() {
        return this.y + this.height / 2.0f;
    }

    @Override
    public float midZ() {
        return this.z + this.depth / 2.0f;
    }

    @Override
    public float maxX() {
        return this.x + this.width;
    }

    @Override
    public float maxY() {
        return this.y + this.height;
    }

    @Override
    public float maxZ() {
        return this.z + this.depth;
    }

    public OpenVector3f center() {
        return new OpenVector3f(this.midX(), this.midY(), this.midZ());
    }

    public OpenVector3f origin() {
        return new OpenVector3f(this.x, this.y, this.z);
    }

    public OpenRectangle3f bounds() {
        return new OpenRectangle3f(-this.width / 2.0f, -this.height / 2.0f, -this.depth / 2.0f, this.width, this.height, this.depth);
    }

    public OpenRectangle3f copy() {
        return new OpenRectangle3f(this.x, this.y, this.z, this.width, this.height, this.depth);
    }

    public OpenRectangle3f scale(float s) {
        return new OpenRectangle3f(this.x * s, this.y * s, this.z * s, this.width * s, this.height * s, this.depth * s);
    }

    public OpenRectangle3f offset(IVector3f point) {
        return this.offset(point.x(), point.y(), point.z());
    }

    public OpenRectangle3f offset(float dx, float dy, float dz) {
        return new OpenRectangle3f(this.x + dx, this.y + dy, this.z + dz, this.width, this.height, this.depth);
    }

    public OpenRectangle3f inflate(float value) {
        if (value == 0.0f) {
            return this;
        }
        float v2 = value + value;
        return new OpenRectangle3f(this.x - value, this.y - value, this.z - value, this.width + v2, this.height + v2, this.depth + v2);
    }

    public void mul(OpenQuaternionf quaternion) {
        this.mul(new OpenMatrix4f(quaternion));
    }

    public void mul(OpenMatrix4f matrix) {
        OpenVector4f start = new OpenVector4f(this.x, this.y, this.z, 1.0f);
        OpenVector4f end = new OpenVector4f(this.x + this.width, this.y + this.height, this.z + this.depth, 1.0f);
        start.transform(matrix);
        end.transform(matrix);
        this.x = Math.min(start.x(), end.x());
        this.y = Math.min(start.y(), end.y());
        this.z = Math.min(start.z(), end.z());
        this.width = Math.max(start.x(), end.x()) - this.x;
        this.height = Math.max(start.y(), end.y()) - this.y;
        this.depth = Math.max(start.z(), end.z()) - this.z;
    }

    public List<Float> toList() {
        return Collections.newList(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.width), Float.valueOf(this.height), Float.valueOf(this.depth));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenRectangle3f)) {
            return false;
        }
        OpenRectangle3f that = (OpenRectangle3f)o;
        return Float.compare(this.x, that.x) == 0 && Float.compare(this.y, that.y) == 0 && Float.compare(this.z, that.z) == 0 && Float.compare(this.width, that.width) == 0 && Float.compare(this.height, that.height) == 0 && Float.compare(this.depth, that.depth) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.width), Float.valueOf(this.height), Float.valueOf(this.depth));
    }

    public String toString() {
        return OpenMath.format("(%f %f %f; %f %f %f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.width), Float.valueOf(this.height), Float.valueOf(this.depth));
    }
}

