/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import java.util.ArrayList;
import java.util.Set;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.blockentity.DyeTableBlockEntity;
import moe.plushie.armourers_workshop.core.item.BottleItem;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.menu.SkinSlot;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinDyeType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_3917;

public class DyeTableMenu
extends AbstractBlockEntityMenu<DyeTableBlockEntity> {
    private final SkinPaintType[] paintTypes = new SkinPaintType[]{SkinPaintTypes.DYE_1, SkinPaintTypes.DYE_2, SkinPaintTypes.DYE_3, SkinPaintTypes.DYE_4, SkinPaintTypes.DYE_5, SkinPaintTypes.DYE_6, SkinPaintTypes.DYE_7, SkinPaintTypes.DYE_8};
    private final class_1263 inventory;
    private ArrayList<SkinPaintType> lockedPaintTypes = new ArrayList();

    public DyeTableMenu(class_3917<?> menuType, class_2248 block, int containerId, class_1661 playerInventory, IGlobalPos access) {
        super((class_3917)menuType, block, containerId, access);
        this.inventory = ((DyeTableBlockEntity)this.blockEntity).getInventory();
        this.addPlayerSlots((class_1263)playerInventory, 8, 108);
        this.addCustomSlots(this.inventory, 68, 36, 22, 22);
        this.addInputSlot(this.inventory, 8, 26, 23);
        this.addOutputSlot(this.inventory, 9, 26, 69);
    }

    public void reload(Set<SkinDyeType> dyeTypes) {
        this.lockedPaintTypes = dyeTypes != null ? Collections.filter(this.paintTypes, it -> !dyeTypes.contains(it.dyeType())) : new ArrayList();
    }

    public class_1799 inputStack() {
        return this.inventory.method_5438(8);
    }

    public class_1799 outputStack() {
        return this.inventory.method_5438(9);
    }

    public void setOutputStack(class_1799 itemStack) {
        this.inventory.method_5447(9, itemStack);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        return this.quickMoveStack(player, index, this.field_7761.size() - 1);
    }

    protected void addInputSlot(final class_1263 inventory, int slot, int x, int y) {
        this.method_7621(new class_1735(inventory, slot, x, y){

            public boolean method_7674(class_1657 player) {
                return false;
            }

            public boolean method_7680(class_1799 itemStack) {
                return !SkinDescriptor.of(itemStack).isEmpty();
            }

            public void method_7668() {
                super.method_7668();
                if (inventory.method_5438(9).method_7960()) {
                    DyeTableMenu.this.loadSkin(this.method_7677());
                }
            }
        });
    }

    protected void addOutputSlot(class_1263 inventory, int slot, int x, int y) {
        this.method_7621(new class_1735(inventory, slot, x, y){

            public boolean method_7680(class_1799 itemStack) {
                return false;
            }

            public void method_7668() {
                super.method_7668();
                if (!this.method_7681()) {
                    DyeTableMenu.this.loadSkin(class_1799.field_8037);
                }
            }
        });
    }

    protected void addCustomSlots(class_1263 inventory, int x, int y, int itemWidth, int itemHeight) {
        for (int i = 0; i < this.paintTypes.length; ++i) {
            int ix = x + i % 4 * itemWidth;
            int iy = y + i / 4 * itemHeight;
            this.method_7621(new LockableSlot(inventory, i, ix, iy, this.paintTypes[i]));
        }
    }

    protected void loadSkin(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            this.inventory.method_5448();
            return;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinPaintScheme scheme = descriptor.paintScheme();
        for (int i = 0; i < this.paintTypes.length; ++i) {
            class_1799 colorStack = class_1799.field_8037;
            SkinPaintColor paintColor = scheme.getColor(this.paintTypes[i]);
            if (paintColor != null) {
                colorStack = new class_1799((class_1935)ModItems.BOTTLE.get());
                ComponentAPI.set(colorStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), paintColor);
            }
            this.inventory.method_5447(i, colorStack);
        }
        this.setOutputStack(itemStack.method_7972());
    }

    protected void applySkin(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return;
        }
        SkinPaintScheme newScheme = new SkinPaintScheme();
        for (int i = 0; i < this.paintTypes.length; ++i) {
            class_1799 colorStack = this.inventory.method_5438(i);
            SkinPaintColor paintColor = (SkinPaintColor)ComponentAPI.get(colorStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
            if (paintColor == null) continue;
            newScheme.setColor(this.paintTypes[i], paintColor);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (newScheme.equals(descriptor.paintScheme())) {
            return;
        }
        descriptor = descriptor.withPaintScheme(newScheme);
        class_1799 newItemStack = itemStack.method_7972();
        ComponentAPI.set(newItemStack, (IDataComponentType)ModDataComponents.SKIN.get(), descriptor);
        this.setOutputStack(newItemStack);
    }

    public class LockableSlot
    extends SkinSlot {
        private final SkinPaintType paintType;

        public LockableSlot(class_1263 inventory, int slot, int x, int y, SkinPaintType paintType) {
            super(inventory, slot, x, y, SkinSlotType.DYE);
            this.paintType = paintType;
        }

        @Override
        public boolean method_7680(class_1799 itemStack) {
            if (DyeTableMenu.this.inputStack().method_7960()) {
                return false;
            }
            return itemStack.method_7909() instanceof BottleItem;
        }

        public void method_7668() {
            super.method_7668();
            DyeTableMenu.this.applySkin(DyeTableMenu.this.outputStack());
        }

        public boolean isLocked() {
            return DyeTableMenu.this.lockedPaintTypes != null && DyeTableMenu.this.lockedPaintTypes.contains(this.paintType);
        }

        public boolean method_7682() {
            return !this.isLocked();
        }
    }
}

