/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.skin.ISkinMarker;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import org.jetbrains.annotations.Nullable;

public class SkinMarker
implements ISkinMarker {
    public static final IDataCodec<SkinMarker> CODEC = IDataCodec.LONG.xmap(SkinMarker::of, SkinMarker::asLong);
    public final byte x;
    public final byte y;
    public final byte z;
    public final byte meta;

    public SkinMarker(byte x, byte y, byte z, byte meta) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.meta = meta;
    }

    public SkinMarker(IInputStream stream) throws IOException {
        this.x = stream.readByte();
        this.y = stream.readByte();
        this.z = stream.readByte();
        this.meta = stream.readByte();
    }

    public static SkinMarker of(long value) {
        long x = value >> 16 & 0xFFL;
        long y = value >> 8 & 0xFFL;
        long z = value & 0xFFL;
        long m = value >> 24 & 0xFFL;
        return new SkinMarker((byte)x, (byte)y, (byte)z, (byte)m);
    }

    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writeByte(this.x);
        stream.writeByte(this.y);
        stream.writeByte(this.z);
        stream.writeByte(this.meta);
    }

    public long asLong() {
        return (long)(this.meta & 0xFF) << 24 | (long)((this.x & 0xFF) << 16) | (long)((this.y & 0xFF) << 8) | (long)(this.z & 0xFF);
    }

    @Override
    public OpenVector3i position() {
        return new OpenVector3i(this.x, this.y, this.z);
    }

    @Override
    @Nullable
    public OpenDirection direction() {
        if (this.meta != 0) {
            return OpenDirection.from3DDataValue(this.meta - 1);
        }
        return null;
    }

    public String toString() {
        return Objects.toString(this, "pos", this.position(), "direction", this.direction());
    }
}

