/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core.ast;

import java.util.function.Function;
import moe.plushie.armourers_workshop.core.skin.molang.core.Assignable;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Name;
import moe.plushie.armourers_workshop.core.skin.molang.core.Optimizable;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.core.Visitor;
import moe.plushie.armourers_workshop.init.ModLog;

public final class StructAccess
implements Expression,
Optimizable,
Assignable {
    private final Expression receiver;
    private final Name name;

    public StructAccess(Expression receiver, String name) {
        this.receiver = receiver;
        this.name = Name.of(name);
    }

    private Result create(ExecutionContext context) {
        Result result = this.receiver.evaluate(context);
        if (result.isNull()) {
            Expression expression = this.receiver;
            if (!(expression instanceof Assignable)) {
                ModLog.warn("Cannot assign a value to {}", this.receiver);
                return Result.NULL;
            }
            Assignable variable = (Assignable)expression;
            result = Result.newStruct();
            variable.assign(result, context);
        }
        return result;
    }

    @Override
    public Result assign(Result value, ExecutionContext context) {
        Result result = this.create(context);
        result.set(this.name, value);
        return value;
    }

    @Override
    public Result assign(Function<Result, Result> operator, ExecutionContext context) {
        Result result = this.create(context);
        Result value = operator.apply(result.get(this.name));
        result.set(this.name, value);
        return value;
    }

    @Override
    public Result evaluate(ExecutionContext context) {
        Result result = this.receiver.evaluate(context);
        return result.get(this.name);
    }

    @Override
    public Expression visit(Visitor visitor) {
        return visitor.visitStructAccess(this);
    }

    @Override
    public boolean isMutable() {
        return this.receiver.isMutable();
    }

    public String toString() {
        return String.valueOf(this.receiver) + "." + String.valueOf(this.name);
    }

    public Expression receiver() {
        return this.receiver;
    }

    public String name() {
        return this.name.toString();
    }
}

