/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime;

import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import org.jetbrains.annotations.Nullable;

public class Scope {
    private Node current;

    public Scope push(Kind kind) {
        this.current = new Node(kind, this.current);
        return this;
    }

    public Result pop() {
        if (this.current != null) {
            Node node = this.current;
            this.current = this.current.parent;
            return node.returnValue;
        }
        return Result.NULL;
    }

    public Scope beginEnumerate() {
        return this.push(Kind.ENUMERATE);
    }

    public Result endEnumerate() {
        return this.pop();
    }

    public State interrupt() {
        if (this.current != null) {
            return this.current.state;
        }
        return State.NONE;
    }

    public void setInterrupt(State state) {
        this.setInterrupt(state, Result.NULL);
    }

    public void setInterrupt(State state, Result result) {
        Kind target = state.kind();
        Node node = this.current;
        while (node != null) {
            node.state = state;
            if (node.kind == target) {
                node.returnValue = result;
                break;
            }
            node = node.parent;
        }
    }

    public boolean isContinueOrBreakOrReturn() {
        return this.interrupt() != State.NONE;
    }

    public boolean isBreakOrReturn() {
        return this.interrupt() == State.BREAK || this.interrupt() == State.RETURN;
    }

    private static class Node {
        private final Kind kind;
        private final Node parent;
        private State state = State.NONE;
        private Result returnValue = Result.NULL;

        Node(Kind kind, Node parent) {
            this.kind = kind;
            this.parent = parent;
        }
    }

    public static enum Kind {
        BLOCK,
        ENUMERATE;

    }

    public static enum State {
        NONE,
        BREAK,
        CONTINUE,
        RETURN;


        @Nullable
        public Kind kind() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 3 -> Kind.BLOCK;
                case 1, 2 -> Kind.ENUMERATE;
                case 0 -> null;
            };
        }
    }
}

