/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime.function.query;

import java.util.List;
import java.util.stream.Collectors;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.BlockSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.EntitySelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.function.EntityFunction;

public class RelativeBlockHasAllTags
extends EntityFunction {
    private final Expression offsetX;
    private final Expression offsetY;
    private final Expression offsetZ;
    private final List<Expression> tags;

    public RelativeBlockHasAllTags(Expression name, List<Expression> arguments) {
        super(name, 4, arguments);
        this.offsetX = arguments.get(0);
        this.offsetY = arguments.get(1);
        this.offsetZ = arguments.get(2);
        this.tags = arguments.stream().skip(3L).collect(Collectors.toList());
    }

    @Override
    public double compute(EntitySelector entity, ExecutionContext context) {
        int offsetX = this.offsetX.evaluate(context).getAsInt();
        int offsetY = this.offsetY.evaluate(context).getAsInt();
        int offsetZ = this.offsetZ.evaluate(context).getAsInt();
        if (Math.abs(offsetX) > 8 || Math.abs(offsetY) > 8 || Math.abs(offsetZ) > 8) {
            return 0.0;
        }
        BlockSelector block = entity.relativeBlock(offsetX, offsetY, offsetZ);
        if (block == null) {
            return 0.0;
        }
        for (Expression tag : this.tags) {
            if (block.hasTag(tag.evaluate(context).getAsString())) continue;
            return 0.0;
        }
        return 1.0;
    }
}

