/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.particle.component.emitter.shape.EmitterShapeDirection;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class EmitterBoxShape
extends SkinParticleComponent {
    private final OpenPrimitive x;
    private final OpenPrimitive y;
    private final OpenPrimitive z;
    private final OpenPrimitive width;
    private final OpenPrimitive height;
    private final OpenPrimitive depth;
    private final EmitterShapeDirection direction;
    private final boolean surface;

    public EmitterBoxShape(OpenPrimitive x, OpenPrimitive y, OpenPrimitive z, OpenPrimitive width, OpenPrimitive height, OpenPrimitive depth, EmitterShapeDirection direction, boolean surface) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.direction = direction;
        this.surface = surface;
    }

    public EmitterBoxShape(IInputStream stream) throws IOException {
        this.x = stream.readPrimitiveObject();
        this.y = stream.readPrimitiveObject();
        this.z = stream.readPrimitiveObject();
        this.width = stream.readPrimitiveObject();
        this.height = stream.readPrimitiveObject();
        this.depth = stream.readPrimitiveObject();
        this.direction = EmitterShapeDirection.readFromStream(stream);
        this.surface = stream.readBoolean();
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.x);
        stream.writePrimitiveObject(this.y);
        stream.writePrimitiveObject(this.z);
        stream.writePrimitiveObject(this.width);
        stream.writePrimitiveObject(this.height);
        stream.writePrimitiveObject(this.depth);
        this.direction.writeToStream(stream);
        stream.writeBoolean(this.surface);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        Expression x = builder.compile(this.x, 0.0);
        Expression y = builder.compile(this.y, 0.0);
        Expression z = builder.compile(this.z, 0.0);
        Expression width = builder.compile(this.width, 0.0);
        Expression height = builder.compile(this.height, 0.0);
        Expression depth = builder.compile(this.depth, 0.0);
        builder.applyParticle((emitter, particle, context) -> {
            double cx = x.compute(context);
            double cy = y.compute(context);
            double cz = z.compute(context);
            double w = width.compute(context);
            double h = height.compute(context);
            double d = depth.compute(context);
        });
    }
}

