/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.particle.appearance;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.math.OpenSize2i;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleFacing;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class ParticleBillboardAppearance
extends SkinParticleComponent {
    private final OpenPrimitive width;
    private final OpenPrimitive height;
    private final SkinParticleFacing facingCameraMode;
    private final OpenSize2i textureSize;
    private final OpenPrimitive textureCoordsX;
    private final OpenPrimitive textureCoordsY;
    private final OpenPrimitive textureCoordsWidth;
    private final OpenPrimitive textureCoordsHeight;
    private final OpenPrimitive stepX;
    private final OpenPrimitive stepY;
    private final boolean isUseAnimation;
    private final int fps;
    private final OpenPrimitive maxFrame;
    private final boolean isStretchToLifetime;
    private final boolean isLoop;

    public ParticleBillboardAppearance(OpenPrimitive width, OpenPrimitive height, SkinParticleFacing facingCameraMode, OpenSize2i textureSize, OpenPrimitive textureCoordsX, OpenPrimitive textureCoordsY, OpenPrimitive textureCoordsWidth, OpenPrimitive textureCoordsHeight, OpenPrimitive stepX, OpenPrimitive stepY, boolean isUseAnimation, int fps, OpenPrimitive maxFrame, boolean isStretchToLifetime, boolean isLoop) {
        this.width = width;
        this.height = height;
        this.facingCameraMode = facingCameraMode;
        this.textureSize = textureSize;
        this.textureCoordsX = textureCoordsX;
        this.textureCoordsY = textureCoordsY;
        this.textureCoordsWidth = textureCoordsWidth;
        this.textureCoordsHeight = textureCoordsHeight;
        this.stepX = stepX;
        this.stepY = stepY;
        this.isUseAnimation = isUseAnimation;
        this.fps = fps;
        this.maxFrame = maxFrame;
        this.isStretchToLifetime = isStretchToLifetime;
        this.isLoop = isLoop;
    }

    public ParticleBillboardAppearance(IInputStream stream) throws IOException {
        this.width = stream.readPrimitiveObject();
        this.height = stream.readPrimitiveObject();
        this.facingCameraMode = stream.readEnum(SkinParticleFacing.class);
        int textureWidth = stream.readInt();
        int textureHeight = stream.readInt();
        this.textureSize = new OpenSize2i(textureWidth, textureHeight);
        this.textureCoordsX = stream.readPrimitiveObject();
        this.textureCoordsY = stream.readPrimitiveObject();
        this.textureCoordsWidth = stream.readPrimitiveObject();
        this.textureCoordsHeight = stream.readPrimitiveObject();
        this.stepX = stream.readPrimitiveObject();
        this.stepY = stream.readPrimitiveObject();
        this.isUseAnimation = stream.readBoolean();
        this.fps = stream.readInt();
        this.maxFrame = stream.readPrimitiveObject();
        this.isStretchToLifetime = stream.readBoolean();
        this.isLoop = stream.readBoolean();
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.width);
        stream.writePrimitiveObject(this.height);
        stream.writeEnum(this.facingCameraMode);
        stream.writeInt(this.textureSize.width());
        stream.writeInt(this.textureSize.height());
        stream.writePrimitiveObject(this.textureCoordsX);
        stream.writePrimitiveObject(this.textureCoordsY);
        stream.writePrimitiveObject(this.textureCoordsWidth);
        stream.writePrimitiveObject(this.textureCoordsHeight);
        stream.writePrimitiveObject(this.stepX);
        stream.writePrimitiveObject(this.stepY);
        stream.writeBoolean(this.isUseAnimation);
        stream.writeInt(this.fps);
        stream.writePrimitiveObject(this.maxFrame);
        stream.writeBoolean(this.isStretchToLifetime);
        stream.writeBoolean(this.isLoop);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
    }
}

