/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.particle.motion;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class ParticleCollisionMotion
extends SkinParticleComponent {
    private final OpenPrimitive enabled;
    private final float collisionDrag;
    private final float collisionRadius;
    private final float coefficientOfRestitution;
    private final boolean expireOnContact;
    private final Map<Float, String> events;

    public ParticleCollisionMotion(OpenPrimitive enabled, float collisionDrag, float collisionRadius, float coefficientOfRestitution, boolean expireOnContact, Map<Float, String> events) {
        this.enabled = enabled;
        this.collisionDrag = collisionDrag;
        this.collisionRadius = collisionRadius;
        this.coefficientOfRestitution = coefficientOfRestitution;
        this.expireOnContact = expireOnContact;
        this.events = events;
    }

    public ParticleCollisionMotion(IInputStream stream) throws IOException {
        this.enabled = stream.readPrimitiveObject();
        this.collisionDrag = stream.readFloat();
        this.collisionRadius = stream.readFloat();
        this.coefficientOfRestitution = stream.readFloat();
        this.expireOnContact = stream.readBoolean();
        this.events = new LinkedHashMap<Float, String>();
        int eventSize = stream.readVarInt();
        for (int i = 0; i < eventSize; ++i) {
            float key = stream.readFloat();
            String value = stream.readString();
            this.events.put(Float.valueOf(key), value);
        }
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.enabled);
        stream.writeFloat(this.collisionDrag);
        stream.writeFloat(this.collisionRadius);
        stream.writeFloat(this.coefficientOfRestitution);
        stream.writeBoolean(this.expireOnContact);
        stream.writeVarInt(this.events.size());
        for (Map.Entry<Float, String> entry : this.events.entrySet()) {
            stream.writeFloat(entry.getKey().floatValue());
            stream.writeString(entry.getValue());
        }
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
    }
}

