/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.impl;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySlice;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializer;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;

public class ChunkGeometrySerializerV1
extends ChunkGeometrySerializer {
    @Override
    public int stride(SkinGeometryType geometryType, int options, ChunkPaletteData palette) {
        int faceCount = options & 0xF;
        return Decoder.calcStride(palette.colorIndexBytes(), faceCount);
    }

    @Override
    public ChunkGeometrySerializer.Encoder<?> encoder(SkinGeometryType geometryType) {
        return new Encoder();
    }

    @Override
    public ChunkGeometrySerializer.Decoder<?> decoder(SkinGeometryType geometryType, ChunkGeometrySlice slice) {
        return new Decoder(geometryType, slice);
    }

    protected static class Decoder
    extends SkinCube
    implements ChunkGeometrySerializer.Decoder<SkinCube> {
        private final int faceCount;
        private final SkinGeometryType type;
        private final ChunkGeometrySlice slice;
        private final ChunkPaletteData palette;

        public Decoder(SkinGeometryType type, ChunkGeometrySlice slice) {
            this.type = type;
            this.palette = slice.palette();
            this.slice = slice;
            this.faceCount = slice.geometryOptions() & 0xF;
        }

        public static int calcStride(int usedBytes, int size) {
            return 3 + (1 + usedBytes) * size;
        }

        @Override
        public SkinCube begin() {
            return this;
        }

        @Override
        public SkinGeometryType type() {
            return this.type;
        }

        @Override
        public OpenRectangle3f boundingBox() {
            if (this.slice.once(0)) {
                float x = this.slice.getByte(0);
                float y = this.slice.getByte(1);
                float z = this.slice.getByte(2);
                this.boundingBox = new OpenRectangle3f(x, y, z, 1.0f, 1.0f, 1.0f);
            }
            return this.boundingBox;
        }

        @Override
        public SkinPaintColor getPaintColor(OpenDirection dir) {
            if (this.slice.once(1)) {
                this.parseColors();
            }
            return super.getPaintColor(dir);
        }

        @Override
        public SkinTexturePos getTexture(OpenDirection dir) {
            return null;
        }

        protected void parseColors() {
            int usedBytes = this.palette.colorIndexBytes();
            for (int i = 0; i < this.faceCount; ++i) {
                byte face = this.slice.getByte(Decoder.calcStride(usedBytes, i));
                SkinPaintColor color = this.slice.getColor(Decoder.calcStride(usedBytes, i) + 1);
                for (OpenDirection dir1 : OpenDirection.valuesFromSet(face)) {
                    this.paintColors.put(dir1, color);
                }
            }
        }
    }

    protected static class Encoder
    implements ChunkGeometrySerializer.Encoder<SkinCube> {
        private OpenVector3i pos = OpenVector3i.ZERO;
        private final LinkedHashMap<SkinPaintColor, Integer> values = new LinkedHashMap();

        protected Encoder() {
        }

        @Override
        public int begin(SkinCube cube) {
            this.pos = cube.blockPos();
            for (OpenDirection dir : OpenDirection.values()) {
                SkinPaintColor value = cube.getPaintColor(dir);
                int face = this.values.getOrDefault(value, 0);
                this.values.put(value, face |= 1 << dir.get3DDataValue());
            }
            return this.values.size();
        }

        @Override
        public void end(ChunkPaletteData palette, ChunkDataOutputStream stream) throws IOException {
            stream.writeByte(this.pos.x());
            stream.writeByte(this.pos.y());
            stream.writeByte(this.pos.z());
            for (Map.Entry<SkinPaintColor, Integer> entry : this.values.entrySet()) {
                stream.writeByte(entry.getValue());
                stream.writeVariable(palette.writeColor(entry.getKey()));
            }
            this.values.clear();
        }
    }
}

