/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintColor;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;

public class SkinPaintColor
implements ISkinPaintColor {
    public static final SkinPaintColor CLEAR = new SkinPaintColor(0, 0, SkinPaintTypes.NONE);
    public static final SkinPaintColor WHITE = new SkinPaintColor(-1, -1, SkinPaintTypes.NORMAL);
    private static final Cache<Integer, SkinPaintColor> POOL = CacheBuilder.newBuilder().maximumSize(2048L).build();
    public static final IDataCodec<SkinPaintColor> CODEC = IDataCodec.INT.alternative(IDataCodec.STRING, SkinPaintColor::parseColor).xmap(SkinPaintColor::of, SkinPaintColor::rawValue);
    protected final int value;
    protected final int rgb;
    protected final SkinPaintType paintType;

    protected SkinPaintColor(int value, int rgb, SkinPaintType paintType) {
        this.value = value;
        this.paintType = paintType;
        this.rgb = rgb;
    }

    public static SkinPaintColor of(int value) {
        if (value != 0) {
            return SkinPaintColor.of(value, SkinPaintColor.getPaintType(value));
        }
        return CLEAR;
    }

    public static SkinPaintColor of(int r, int g, int b, SkinPaintType paintType) {
        return SkinPaintColor.of(r << 16 | g << 8 | b, paintType);
    }

    public static SkinPaintColor of(int rgb, SkinPaintType paintType) {
        int value = rgb & 0xFFFFFF | (paintType.id() & 0xFF) << 24;
        SkinPaintColor paintColor = (SkinPaintColor)POOL.getIfPresent((Object)value);
        if (paintColor == null) {
            paintColor = new SkinPaintColor(value, rgb | 0xFF000000, paintType);
            POOL.put((Object)value, (Object)paintColor);
        }
        return paintColor;
    }

    public static SkinPaintType getPaintType(int value) {
        return SkinPaintTypes.byId(value >> 24 & 0xFF);
    }

    public static int parseColor(String colorString) {
        try {
            int value = Integer.decode(colorString);
            if ((value & 0xFF000000) == 0) {
                value |= 0xFF000000;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static boolean isOpaque(int color) {
        return (color & 0xFF000000) != 0;
    }

    public boolean isEmpty() {
        return this.paintType() == SkinPaintTypes.NONE;
    }

    @Override
    public int red() {
        return this.rgb >> 16 & 0xFF;
    }

    @Override
    public int green() {
        return this.rgb >> 8 & 0xFF;
    }

    @Override
    public int blue() {
        return this.rgb & 0xFF;
    }

    @Override
    public int argb() {
        return this.rgb;
    }

    @Override
    public int rawValue() {
        return this.value;
    }

    @Override
    public SkinPaintType paintType() {
        return this.paintType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinPaintColor)) {
            return false;
        }
        SkinPaintColor that = (SkinPaintColor)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.format("#%08x", this.value);
    }

    @Override
    public SkinPaintColor withPaintType(ISkinPaintType paintType) {
        return SkinPaintColor.of(this.rgb, (SkinPaintType)paintType);
    }

    @Override
    public SkinPaintColor withColor(int argb) {
        return SkinPaintColor.of(argb, this.paintType);
    }

    @Override
    public SkinPaintColor withColor(int red, int green, int blue) {
        return SkinPaintColor.of(red, green, blue, this.paintType);
    }
}

