/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Objects {
    public static <S, T> T unsafeCast(S src) {
        return (T)src;
    }

    @Nullable
    public static <S, T> T safeCast(S src, Class<T> type) {
        if (type.isInstance(src)) {
            return type.cast(src);
        }
        return null;
    }

    public static <S, T> T flatMap(S src, Function<S, T> consumer) {
        if (src != null) {
            return consumer.apply(src);
        }
        return null;
    }

    public static <S, V> V flatMap(S obj, Function<S, V> getter, V defaultValue) {
        V value;
        if (obj != null && (value = getter.apply(obj)) != null) {
            return value;
        }
        return defaultValue;
    }

    public static <S> S compactMap(S value, S defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static boolean equals(Object a, Object b) {
        return java.util.Objects.equals(a, b);
    }

    public static String toString(Object obj, Object ... arguments) {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(Objects.getClassName(obj.getClass()));
        builder.append(": ");
        builder.append(String.format("0x%x", System.identityHashCode(obj)));
        for (int i = 0; i < arguments.length; i += 2) {
            if (Objects.isEmptyOrNull(arguments[i + 1])) continue;
            builder.append("; ");
            builder.append(arguments[i]);
            builder.append(" = ");
            builder.append(arguments[i + 1]);
        }
        builder.append(">");
        return builder.toString();
    }

    private static String getClassName(Class<?> clazz) {
        String name = clazz.getTypeName();
        Package pkg = clazz.getPackage();
        if (pkg != null) {
            return name.replace(pkg.getName() + ".", "");
        }
        return clazz.getSimpleName();
    }

    private static boolean isEmptyOrNull(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.isEmpty();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return stringValue.isEmpty();
        }
        return false;
    }

    public static String dumpStackTrace() {
        StackTraceElement[] ste;
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement st : ste = Thread.currentThread().getStackTrace()) {
            sb.append(st.toString()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        int dataLen = data.length;
        char[] out = new char[dataLen << 1];
        boolean dataOffset = false;
        boolean outOffset = false;
        String toDigits = "0123456789ABCDEF";
        if (toLowerCase) {
            toDigits = "0123456789abcdef";
        }
        int j = 0;
        for (int i = 0; i < 0 + dataLen; ++i) {
            out[j++] = toDigits.charAt((0xF0 & data[i]) >>> 4);
            out[j++] = toDigits.charAt(0xF & data[i]);
        }
        return out;
    }

    public static byte[] decodeHex(char[] data) throws IllegalArgumentException {
        int len = data.length;
        boolean outOffset = false;
        byte[] out = new byte[len >> 1];
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        int i = 0;
        int j = 0;
        while (j < len) {
            int f1 = Character.digit(data[j], 16);
            int f2 = Character.digit(data[j + 1], 16);
            if (f1 == -1) {
                throw new IllegalArgumentException("Illegal hexadecimal character " + f1 + " at index " + j);
            }
            if (f2 == -1) {
                throw new IllegalArgumentException("Illegal hexadecimal character " + f2 + " at index " + j + "1");
            }
            int f = f1 << 4 | f2;
            out[i] = (byte)(f & 0xFF);
            j += 2;
            ++i;
        }
        return out;
    }

    public static String md5(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] sig = md.digest(value.getBytes(StandardCharsets.UTF_8));
            return new String(Objects.encodeHex(sig, true));
        }
        catch (Exception e) {
            e.printStackTrace();
            return value;
        }
    }
}

