/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.player.AbstractClientPlayer.ABI;
import moe.plushie.armourers_workshop.core.client.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.client.texture.EntityTexture;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1043;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class TextureUtils {
    public static IResourceLocation registerTexture(String key, class_1043 texture) {
        class_2960 location = class_310.method_1551().method_1531().method_4617(key, texture);
        return OpenResourceLocation.create(location);
    }

    public static OpenResourceLocation getTexture(class_1297 entity) {
        if (entity instanceof class_742) {
            class_742 player = (class_742)entity;
            class_2960 location = ABI.getSkin(player).texture();
            return OpenResourceLocation.create(location);
        }
        return ModTextures.MANNEQUIN_DEFAULT;
    }

    public static OpenResourceLocation getPlayerTextureLocation(EntityTextureDescriptor descriptor) {
        EntityTexture bakedTexture = EntityTextureLoader.getInstance().loadTexture(descriptor);
        if (bakedTexture != null && bakedTexture.isDownloaded()) {
            return bakedTexture.location();
        }
        return ModTextures.MANNEQUIN_DEFAULT;
    }

    @Nullable
    public static BakedEntityTexture getPlayerTextureModel(EntityTextureDescriptor descriptor) {
        OpenResourceLocation texture = TextureUtils.getPlayerTextureLocation(descriptor);
        if (texture != null) {
            return EntityTextureLoader.getInstance().getTextureModel(texture);
        }
        return null;
    }

    public static SkinPaintColor getPlayerTextureModelColor(EntityTextureDescriptor descriptor, OpenVector2i texturePos) {
        BakedEntityTexture textureModel = TextureUtils.getPlayerTextureModel(descriptor);
        if (textureModel != null) {
            return textureModel.getColor(texturePos);
        }
        return null;
    }
}

