/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentPose;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentType;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentTypes;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

@Environment(value=EnvType.CLIENT)
public class ClientAttachmentHandler {
    private static final OpenVector3f GUN_LEFT_WAIST_ORIGIN = new OpenVector3f(-4.0f, 12.0f, 0.0f);
    private static final OpenVector3f GUN_RIGHT_WAIST_ORIGIN = new OpenVector3f(4.0f, 12.0f, 0.0f);
    private static final OpenVector3f GUN_BACKPACK_ORIGIN = new OpenVector3f(0.0f, 24.0f, 2.0f);

    public static void onRenderName(class_1297 entity, class_2561 name, class_4587 poseStackIn, class_4597 bufferSourceIn) {
        ClientAttachmentHandler.apply(entity, SkinAttachmentTypes.NAME, 0, poseStackIn, bufferSourceIn, (poseStack, attachmentPose, index) -> {
            OpenVector3f offset1 = OpenVector3f.ZERO.transforming(poseStack.last().pose());
            OpenVector3f offset2 = OpenVector3f.ZERO.transforming(attachmentPose.pose());
            float dx = offset2.x() - offset1.x();
            float dy = offset2.y() + 0.5f - offset1.y();
            float dz = offset2.z() - offset1.z();
            poseStack.translate(dx, dy, dz);
        });
    }

    public static void onRenderHand(class_1297 entity, class_1799 itemStack, OpenItemDisplayContext displayContext, class_4587 poseStackIn, class_4597 bufferSourceIn, Consumer<class_1799> handler) {
        SkinAttachmentType attachmentType = switch (displayContext) {
            case OpenItemDisplayContext.FIRST_PERSON_LEFT_HAND, OpenItemDisplayContext.THIRD_PERSON_LEFT_HAND -> SkinAttachmentTypes.LEFT_HAND;
            case OpenItemDisplayContext.FIRST_PERSON_RIGHT_HAND, OpenItemDisplayContext.THIRD_PERSON_RIGHT_HAND -> SkinAttachmentTypes.RIGHT_HAND;
            default -> SkinAttachmentTypes.UNKNOWN;
        };
        ClientAttachmentHandler.applyMultiple(entity, attachmentType, poseStackIn, bufferSourceIn, (poseStack, attachmentPose, index) -> {
            if (poseStack != null && attachmentPose != null) {
                poseStack.last().set(attachmentPose);
                poseStack.rotate(OpenVector3f.XP.rotationDegrees(-90.0f));
                poseStack.rotate(OpenVector3f.YP.rotationDegrees(180.0f));
            }
            handler.accept(itemStack);
        });
    }

    public static void onRenderParrot(class_1297 entity, boolean isLeft, class_4587 poseStackIn, class_4597 bufferSourceIn) {
        SkinAttachmentType attachmentType = SkinAttachmentTypes.RIGHT_SHOULDER;
        if (isLeft) {
            attachmentType = SkinAttachmentTypes.LEFT_SHOULDER;
        }
        ClientAttachmentHandler.apply(entity, attachmentType, 0, poseStackIn, bufferSourceIn, (poseStack, attachmentPose, index) -> {
            poseStack.last().set(attachmentPose);
            poseStack.translate(0.0f, -1.5f, 0.0f);
        });
    }

    public static void onRenderGun(class_1297 entity, class_1799 itemStack, OpenVector3f offset, class_4587 poseStackIn, class_4597 bufferSourceIn) {
        SkinAttachmentType attachmentType = SkinAttachmentTypes.BACKPACK;
        OpenVector3f attachmentOrigin = GUN_BACKPACK_ORIGIN;
        float tx = offset.x();
        float ty = offset.y();
        float tz = offset.z();
        if (ty < 16.0f) {
            if (tx < 0.0f) {
                attachmentType = SkinAttachmentTypes.LEFT_WAIST;
                attachmentOrigin = GUN_LEFT_WAIST_ORIGIN;
            } else {
                attachmentType = SkinAttachmentTypes.RIGHT_WAIST;
                attachmentOrigin = GUN_RIGHT_WAIST_ORIGIN;
            }
        }
        float dx = (tx - attachmentOrigin.x()) / 16.0f;
        float dy = (ty - attachmentOrigin.y()) / 16.0f;
        float dz = (tz - attachmentOrigin.z()) / 16.0f;
        ClientAttachmentHandler.apply(entity, attachmentType, 0, poseStackIn, bufferSourceIn, (poseStack, attachmentPose, index) -> {
            poseStack.last().set(attachmentPose);
            poseStack.translate(-dx, -dy, dz);
        });
    }

    private static void apply(class_1297 entity, SkinAttachmentType attachmentType, int index, class_4587 poseStackIn, class_4597 buffersIn, Applier applier) {
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        SkinAttachmentPose attachmentPose = renderData.getAttachmentPose(attachmentType, index);
        if (attachmentPose == null) {
            return;
        }
        IPoseStack poseStack = AbstractPoseStack.wrap(poseStackIn);
        applier.apply(poseStack, attachmentPose, index);
    }

    private static void applyMultiple(class_1297 entity, SkinAttachmentType attachmentType, class_4587 poseStackIn, class_4597 buffersIn, Applier applier) {
        SkinAttachmentPose attachmentPose2;
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData == null) {
            applier.apply(null, null, 0);
            return;
        }
        IPoseStack poseStack = AbstractPoseStack.wrap(poseStackIn);
        Int2ObjectMap<SkinAttachmentPose> attachmentPoses = renderData.getAttachmentPoses(attachmentType);
        if (attachmentPoses != null) {
            attachmentPoses.forEach((index, attachmentPose) -> {
                poseStack.pushPose();
                applier.apply(poseStack, (SkinAttachmentPose)attachmentPose, (int)index);
                poseStack.popPose();
            });
            if (attachmentPoses.containsKey(0)) {
                return;
            }
        }
        if ((attachmentPose2 = renderData.getAttachmentPose(attachmentType, 0)) == null) {
            applier.apply(null, null, 0);
            return;
        }
        applier.apply(poseStack, attachmentPose2, 0);
    }

    private static interface Applier {
        public void apply(IPoseStack var1, SkinAttachmentPose var2, int var3);
    }
}

