/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UILabelDelegate;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.Map;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.logging.log4j.util.Strings;

@Environment(value=EnvType.CLIENT)
public class JoinLibraryPanel
extends AbstractLibraryPanel
implements UILabelDelegate {
    private static final String URL_DISCORD = "https://discord.gg/5Z3KKvU";
    private static final String URL_WIKI_FAQ = "https://github.com/Armourers-Workshop/Armourers-Workshop/wiki/FAQ";
    private static final String URL_VIDEO_UPDATE_JAVA = "https://youtu.be/xZfaXHulmKo";
    private final ArrayList<NSMutableString> pages = new ArrayList();
    private final UILabel label = new UILabel(CGRect.ZERO);
    private final UIButton buttonPrevious = new UIButton(CGRect.ZERO);
    private final UIButton buttonNext = new UIButton(CGRect.ZERO);
    private final UIButton buttonJoin = new UIButton(CGRect.ZERO);
    private int page = 0;
    private String joinFailMessage = null;
    private boolean joining = false;

    public JoinLibraryPanel() {
        super("skin-library-global.join", GlobalSkinLibraryWindow.Page.LIBRARY_JOIN::equals);
        this.remake();
        this.setup(this.bounds());
    }

    private void setup(CGRect rect) {
        float recWidth = 318.0f;
        float recHeight = 180.0f;
        UIView contentView = new UIView(new CGRect((rect.width - recWidth) / 2.0f, (rect.height - recHeight) / 2.0f, recWidth, recHeight));
        contentView.setContents(ModTextures.defaultWindowImage());
        contentView.setAutoresizingMask(45);
        this.addSubview(contentView);
        this.label.setFrame(contentView.bounds().insetBy(5.0f, 5.0f, 5.0f, 5.0f));
        this.label.setNumberOfLines(0);
        this.label.setTextVerticalAlignment(NSTextAlignment.Vertical.TOP);
        this.label.setTextColor(UIColor.of(-13421773));
        this.label.setDelegate(this);
        contentView.addSubview(this.label);
        CGRect frame = this.label.frame();
        float buttonBottom = frame.maxY() - 16.0f;
        this.buttonPrevious.setFrame(new CGRect(frame.minX(), buttonBottom, 16.0f, 16.0f));
        this.buttonPrevious.setTooltip(NSString.localizedString("common.button.previousPage", new Object[0]));
        this.buttonPrevious.setImage(ModTextures.iconImage(208.0f, 80.0f, 16.0f, 16.0f, ModTextures.BUTTONS), 7);
        this.buttonPrevious.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, JoinLibraryPanel::previous);
        contentView.addSubview(this.buttonPrevious);
        this.buttonNext.setFrame(new CGRect(frame.maxX() - 16.0f, buttonBottom, 16.0f, 16.0f));
        this.buttonNext.setTooltip(NSString.localizedString("common.button.nextPage", new Object[0]));
        this.buttonNext.setImage(ModTextures.iconImage(208.0f, 96.0f, 16.0f, 16.0f, ModTextures.BUTTONS), 7);
        this.buttonNext.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, JoinLibraryPanel::next);
        contentView.addSubview(this.buttonNext);
        this.buttonJoin.setFrame(new CGRect(frame.midX() - 70.0f, buttonBottom, 140.0f, 16.0f));
        this.buttonJoin.setTitle(this.getDisplayText("button.join", new Object[0]), 0);
        this.buttonJoin.setTitleColor(UIColor.WHITE, 0);
        this.buttonJoin.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        this.buttonJoin.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, JoinLibraryPanel::join);
        contentView.addSubview(this.buttonJoin);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.page = 0;
        this.remake();
        this.refreshStatus();
    }

    @Override
    public void labelWillClickAttributes(UILabel label, Map<String, ?> attributes) {
        if (this.router != null) {
            this.router.labelWillClickAttributes(label, attributes);
        }
    }

    private void previous(UIControl button) {
        this.setPage(this.page - 1);
    }

    private void next(UIControl button) {
        this.setPage(this.page + 1);
    }

    private void join(UIControl button) {
        this.joining = true;
        this.joinFailMessage = null;
        GlobalSkinLibrary.getInstance().join((Void result, Exception exception) -> {
            if (exception != null) {
                this.onJoinedFailed(exception.getMessage());
            } else {
                this.onJoined();
            }
        });
        this.refreshStatus();
    }

    private void onJoined() {
        this.joining = false;
        this.joinFailMessage = "";
        this.router.showNewHome();
    }

    private void onJoinedFailed(String message) {
        this.joining = false;
        this.joinFailMessage = message;
        this.remake();
        this.refreshStatus();
    }

    private void refreshStatus() {
        boolean canJoin = this.pages.size() != 1;
        boolean isLast = this.page == this.pages.size() - 1;
        this.label.setText(this.pages.get(this.page));
        this.buttonPrevious.setEnabled(this.page != 0);
        this.buttonNext.setEnabled(!isLast);
        this.buttonNext.setHidden(!canJoin);
        this.buttonPrevious.setHidden(!canJoin);
        this.buttonJoin.setHidden(!canJoin || !isLast);
        this.buttonJoin.setEnabled(!this.joining);
    }

    private void remake() {
        this.pages.clear();
        GlobalSkinLibrary library = GlobalSkinLibrary.getInstance();
        if (!library.isValidJavaVersion()) {
            String[] javaVersion = library.getJavaVersion();
            NSString urlWikiFaq = this.getURLText(URL_WIKI_FAQ);
            NSString urlVideoUpdateJava = this.getURLText(URL_VIDEO_UPDATE_JAVA);
            String update = javaVersion.length > 2 ? javaVersion[2] : "0";
            this.pages.add(this.concat(this.getDisplayText("old_java", javaVersion[0], update, urlWikiFaq, urlVideoUpdateJava)));
            return;
        }
        this.pages.add(this.concat(this.getDisplayText("message_1.title", new Object[0]), "\n\n", this.getDisplayText("message_1.text", new Object[0])));
        this.pages.add(this.concat(this.getDisplayText("message_2.title", new Object[0]), "\n\n", this.getDisplayText("message_2.text", new Object[0])));
        this.pages.add(this.concat(this.getDisplayText("message_3.title", new Object[0]), "\n\n", this.getDisplayText("message_3.text", new Object[0])));
        this.pages.add(this.concat(this.getDisplayText("message_4.title", new Object[0]), "\n\n", this.getDisplayText("message_4.text", new Object[0])));
        this.pages.add(this.concat(this.getDisplayText("message_5.title", new Object[0]), "\n\n", this.getDisplayText("message_5.text", new Object[0]), this.getURLText(URL_DISCORD)));
        if (Strings.isNotBlank((String)this.joinFailMessage)) {
            NSMutableString message = this.pages.get(this.pages.size() - 1);
            message.append("\n\n");
            message.append("\u00a7cError: " + this.joinFailMessage + "\u00a7r");
            message.append("\n\n");
        }
        if (this.label != null) {
            this.label.setText(this.pages.get(this.page));
        }
    }

    private void setPage(int page) {
        if (page < 0 || page >= this.pages.size()) {
            return;
        }
        this.page = page;
        this.refreshStatus();
    }

    private NSMutableString concat(Object ... keys) {
        NSMutableString message = new NSMutableString("");
        for (Object key : keys) {
            Object str;
            if (key instanceof String) {
                str = (String)key;
                message.append((String)str);
            }
            if (!(key instanceof NSString)) continue;
            str = (NSString)key;
            message.append((NSString)str);
        }
        return message;
    }
}

