/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels;

import com.apple.library.coregraphics.CGGradient;
import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIScreen;
import com.apple.library.uikit.UIView;
import java.io.File;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.Fix18;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.gui.notification.UserNotificationCenter;
import moe.plushie.armourers_workshop.core.client.gui.widget.ReportDialog;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.widget.SkinRatingView;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.library.data.impl.ReportType;
import moe.plushie.armourers_workshop.library.data.impl.ServerPermission;
import moe.plushie.armourers_workshop.library.data.impl.ServerSkin;
import moe.plushie.armourers_workshop.library.data.impl.ServerUser;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.apache.logging.log4j.util.Strings;

@Environment(value=EnvType.CLIENT)
public class SkinDetailLibraryPanel
extends AbstractLibraryPanel {
    private UIButton buttonBack;
    private UIButton buttonDownload;
    private UIButton buttonUserSkins;
    private UIButton buttonEditSkin;
    private UIButton buttonReportSkin;
    private final SkinRatingView buttonStarRating = new SkinRatingView(CGRect.ZERO);
    private int userRating = 0;
    private boolean doneRatingCheck = false;
    private CGGradient gradient;
    private CGRect skinInfoFrame = CGRect.ZERO;
    private CGRect previewFrame = CGRect.ZERO;
    private CGRect userFrame = CGRect.ZERO;
    private NSString message;
    private ServerSkin entry;
    private GlobalSkinLibraryWindow.Page returnPage;
    private EntityTextureDescriptor playerTexture = EntityTextureDescriptor.EMPTY;
    private final Ticket loadTicket = Ticket.wardrobe();
    private final GlobalSkinLibrary library = GlobalSkinLibrary.getInstance();

    public SkinDetailLibraryPanel() {
        super("skin-library-global.skinInfo", GlobalSkinLibraryWindow.Page.SKIN_DETAIL::equals);
        this.setup();
    }

    private void setup() {
        this.gradient = new CGGradient(UIColor.of(0x22888888), CGPoint.ZERO, UIColor.of(0x22CCCCCC), CGPoint.ZERO);
        CGRect bounds = this.bounds();
        float minX = 2.0f;
        float maxX = bounds.width - 2.0f;
        float midX = minX + 185.0f + 2.0f;
        this.buttonUserSkins = this.addTextButton(minX + 2.0f, 4.0f, 26.0f, 26.0f, "", SkinDetailLibraryPanel::searchUser);
        this.buttonUserSkins.addSubview(new HeadView(new CGRect(5.0f, 5.0f, 16.0f, 16.0f)));
        this.buttonStarRating.setFrame(new CGRect(191.0f, 4.0f, 16.0f, 16.0f));
        this.buttonStarRating.setMaxValue(10);
        this.buttonStarRating.setValue(this.userRating);
        this.buttonStarRating.addTarget(this, UIControl.Event.VALUE_CHANGED, SkinDetailLibraryPanel::updateSkinRating);
        this.addSubview(this.buttonStarRating);
        this.buttonDownload = this.addTextButton(midX + 2.0f, bounds.height - 38.0f, 76.0f, 16.0f, "downloadSkin", SkinDetailLibraryPanel::downloadSkin);
        this.buttonDownload.setAutoresizingMask(12);
        this.buttonReportSkin = this.addTextButton(maxX - 80.0f, bounds.height - 38.0f, 76.0f, 16.0f, "button.report_skin", SkinDetailLibraryPanel::reportSkinPre);
        this.buttonReportSkin.setAutoresizingMask(9);
        this.buttonBack = this.addTextButton(minX, bounds.height - 18.0f, 80.0f, 16.0f, "back", SkinDetailLibraryPanel::backToHome);
        this.buttonBack.setAutoresizingMask(12);
        this.buttonEditSkin = this.addTextButton(maxX - 80.0f, bounds.height - 18.0f, 80.0f, 16.0f, "editSkin", SkinDetailLibraryPanel::editSkin);
        this.buttonEditSkin.setAutoresizingMask(9);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect bounds = this.bounds();
        this.skinInfoFrame = new CGRect(2.0f, 34.0f, 185.0f, bounds.height - 54.0f);
        this.previewFrame = new CGRect(189.0f, 2.0f, bounds.width - 189.0f - 2.0f, bounds.height - 22.0f);
        this.userFrame = new CGRect(2.0f, 2.0f, 185.0f, 30.0f);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.buttonUserSkins == null) {
            return;
        }
        ServerUser user = GlobalSkinLibrary.getInstance().user();
        this.buttonEditSkin.setHidden(true);
        if (this.entry != null && user.equals(this.entry.user())) {
            this.buttonEditSkin.setHidden(!user.hasPermission(ServerPermission.SKIN_OWNER_EDIT));
        } else {
            this.buttonEditSkin.setHidden(!user.hasPermission(ServerPermission.SKIN_MOD_EDIT));
        }
        this.buttonDownload.setHidden(!user.hasPermission(ServerPermission.SKIN_DOWNLOAD));
    }

    public void reloadData(ServerSkin entry, GlobalSkinLibraryWindow.Page returnPage) {
        this.returnPage = returnPage;
        this.userRating = 0;
        this.doneRatingCheck = false;
        this.buttonDownload.setEnabled(true);
        this.reloadUI(entry);
        this.updateSkinJson();
        if (GlobalSkinLibrary.getInstance().user().isMember()) {
            this.checkIfLiked();
        }
    }

    public void reloadUI(ServerSkin entry) {
        this.loadTicket.invalidate();
        this.entry = entry;
        this.message = this.message();
        this.playerTexture = EntityTextureDescriptor.EMPTY;
        this.updateLikeButtons();
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        this.drawSkinInfo(context, this.skinInfoFrame);
        this.drawPreviewBox(context, this.previewFrame);
        this.drawUserbox(context, this.userFrame);
    }

    public void drawUserbox(CGGraphicsContext context, CGRect rect) {
        ServerUser user;
        context.fillRect(this.gradient, rect);
        if (this.playerTexture.isEmpty() && !(user = this.entry.user()).name().isEmpty()) {
            this.playerTexture = EntityTextureDescriptor.fromName(user.name());
        }
        if (Strings.isNotBlank((String)this.playerTexture.name())) {
            context.drawText(this.getDisplayText("uploader", this.playerTexture.name()), rect.x + 32.0f, rect.y + 12.0f, -1118482);
            Fix18.enableAlphaTest(RenderSystem.class);
        }
    }

    public void drawSkinInfo(CGGraphicsContext context, CGRect rect) {
        context.fillRect(this.gradient, rect);
        if (this.message == null) {
            return;
        }
        context.addClip(UIScreen.convertRectFromView(rect, this));
        context.drawMultilineText(this.message, rect.x + 2.0f, rect.y + 2.0f, rect.width - 4.0f, -1118482, UIFont.systemFont());
        context.removeClip();
    }

    public void drawPreviewBox(CGGraphicsContext context, CGRect rect) {
        context.fillRect(this.gradient, rect);
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(this.entry.descriptor(), this.loadTicket);
        if (bakedSkin != null) {
            float tx = rect.x;
            float ty = rect.y;
            float tw = rect.width;
            float th = rect.height;
            AbstractBufferSource buffers = AbstractBufferSource.buffer();
            ExtendedItemRenderer.renderSkinInGUI(bakedSkin, tx, ty, 100.0f, tw, th, 20.0f, 45.0f, 0.0f, context.state().ctm(), buffers);
            buffers.endBatch();
        }
    }

    private UIButton addTextButton(float x, float y, float width, float height, String key, BiConsumer<SkinDetailLibraryPanel, UIControl> handler) {
        NSString title = new NSString("");
        if (!key.isEmpty()) {
            title = this.getDisplayText(key, new Object[0]);
        }
        UIButton button = new UIButton(new CGRect(x, y, width, height));
        button.setTitle(title, 0);
        button.setTitleColor(UIColor.WHITE, 0);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, handler);
        this.addSubview(button);
        return button;
    }

    private void backToHome(UIControl button) {
        this.router.showPage(this.returnPage);
    }

    private void searchUser(UIControl button) {
        this.router.showSkinList(this.entry.user());
    }

    private void editSkin(UIControl button) {
        this.router.showSkinEdit(this.entry, this.returnPage);
    }

    private void updateSkinRating(UIControl button) {
        this.setSkinRating(this.buttonStarRating.value());
    }

    private void reportSkinPre(UIControl button) {
        ReportType[] reportTypes = ReportType.values();
        ReportDialog dialog = new ReportDialog();
        dialog.setTitle(this.getDisplayText("dialog.report_skin.title", new Object[0]));
        dialog.setMessageColor(UIColor.of(-8454144));
        dialog.setMessage(this.getDisplayText("dialog.report_skin.label.report_warning", new Object[0]));
        dialog.setPlaceholder(this.getDisplayText("dialog.report_skin.optional_message", new Object[0]));
        dialog.setReportTypes(Collections.compactMap(reportTypes, t -> new NSString((class_2561)TranslateUtils.title(t.toLangKey(), new Object[0]))));
        dialog.showInView(this, () -> {
            if (!dialog.isCancelled()) {
                ReportType reportType = reportTypes[dialog.reportType()];
                this.reportSkin(dialog.text(), reportType);
            }
        });
    }

    private void reportSkin(String message, ReportType reportType) {
        ModLog.debug("report skin: '{}', text: '{}', type: {}", new Object[]{this.entry.id(), message, reportType});
        this.entry.report(message, reportType, (result, exception) -> {
            if (exception == null) {
                ModLog.debug("skin report sent.", new Object[0]);
            }
        });
    }

    private void downloadSkin(UIControl button) {
        String skinId = this.entry.id();
        String idString = this.leftZeroPadding(skinId, 5);
        String skinName = this.entry.name();
        File path = new File(EnvironmentManager.getSkinLibraryDirectory(), "downloads");
        File target = new File(path, this.makeFileNameValid(idString + " - " + skinName + ".armour"));
        SkinDescriptor skinDescriptor = this.entry.descriptor();
        this.buttonDownload.setEnabled(false);
        GlobalSkinLibrary.getInstance().downloadSkin(this.entry.id(), target, (result, exception) -> {
            if (exception != null) {
                this.buttonDownload.setEnabled(true);
                UserNotificationCenter.showToast(exception, new NSString(skinName), (Object)skinDescriptor.asItemStack());
            } else {
                SkinLibraryManager.getClient().localLibrary().reload();
                UserNotificationCenter.showToast(this.getDisplayText("downloadFinished", new Object[0]), new NSString(skinName), (Object)skinDescriptor.asItemStack());
            }
        });
    }

    private void updateLikeButtons() {
        this.buttonStarRating.setHidden(true);
        if (this.doneRatingCheck) {
            this.buttonStarRating.setValue(this.userRating);
            this.buttonStarRating.setHidden(false);
        }
    }

    private void checkIfLiked() {
        this.entry.getRate((result, exception) -> {
            if (result != null) {
                this.userRating = result;
                this.doneRatingCheck = true;
                this.reloadUI(this.entry);
            }
        });
    }

    public String makeFileNameValid(String fileName) {
        fileName = fileName.replaceAll("[<>:\"/\\\\|?*]", "_");
        return fileName;
    }

    private String leftZeroPadding(String inputString, int length) {
        if (inputString.length() >= length) {
            return inputString;
        }
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length - inputString.length()) {
            sb.append('0');
        }
        sb.append(inputString);
        return sb.toString();
    }

    private void setSkinRating(int rating) {
        boolean isNew = this.userRating == 0;
        this.userRating = rating;
        this.entry.updateRate(rating, (result, exception) -> {
            if (exception == null) {
                if (isNew) {
                    this.entry.ratingCount(this.entry.ratingCount() + 1);
                }
                this.reloadUI(this.entry);
            }
        });
    }

    private void updateSkinJson() {
    }

    private NSString message() {
        BakedSkin bakedSkin;
        NSMutableString message = new NSMutableString("");
        message.append(this.getDisplayText("title", new Object[0]));
        message.append("\n\n");
        if (this.entry == null) {
            return message;
        }
        message.append(this.getDisplayText("name", new Object[0]));
        message.append(" ");
        message.append(this.entry.name());
        message.append("\n\n");
        if (this.entry.showsDownloads) {
            message.append(this.getDisplayText("downloads", new Object[0]));
            message.append(" ");
            message.append("" + this.entry.downloads());
            message.append("\n\n");
        }
        if (this.entry.showsRating) {
            message.append(this.getDisplayText("rating", new Object[0]));
            message.append(" ");
            message.append(String.format("(%d) %.1f/10.0", this.entry.ratingCount(), Float.valueOf(this.entry.rating())));
            message.append("\n\n");
        }
        if ((bakedSkin = SkinBakery.getInstance().loadSkin(this.entry.descriptor(), this.loadTicket)) != null && bakedSkin.skin() != null) {
            message.append(this.getDisplayText("author", new Object[0]));
            message.append(" ");
            message.append(bakedSkin.skin().authorName());
            message.append("\n\n");
        }
        if (this.entry.showsGlobalId) {
            message.append(this.getDisplayText("global_id", new Object[0]));
            message.append(" ");
            message.append(this.entry.id());
            message.append("\n\n");
        }
        if (Strings.isNotBlank((String)this.entry.description())) {
            message.append(this.getDisplayText("description", new Object[0]));
            message.append(" ");
            message.append(this.entry.description());
            message.append("\n\n");
        }
        return message;
    }

    private class HeadView
    extends UIView {
        public HeadView(CGRect frame) {
            super(frame);
        }

        @Override
        public void render(CGPoint point, CGGraphicsContext context) {
            super.render(point, context);
            OpenResourceLocation texture = EntityTextureLoader.getInstance().getTextureLocation(SkinDetailLibraryPanel.this.playerTexture);
            context.drawResizableImage(texture, 0.0f, 0.0f, 16.0f, 16.0f, 8.0f, 8.0f, 8.0f, 8.0f, 64.0f, 64.0f, 0.0f);
            context.drawResizableImage(texture, -1.0f, -1.0f, 18.0f, 18.0f, 40.0f, 8.0f, 8.0f, 8.0f, 64.0f, 64.0f, 0.0f);
        }
    }
}

