/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextView;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.data.impl.ServerSkin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.logging.log4j.util.Strings;

@Environment(value=EnvType.CLIENT)
public class SkinEditLibraryPanel
extends AbstractLibraryPanel {
    private UITextField textName;
    private UITextField textTags;
    private UITextView textDescription;
    private UIButton buttonUpdate;
    private UIButton buttonDelete;
    private ServerSkin entry;
    private GlobalSkinLibraryWindow.Page returnPage;

    public SkinEditLibraryPanel() {
        super("skin-library-global.edit", GlobalSkinLibraryWindow.Page.SKIN_EDIT::equals);
        this.setup();
    }

    private void setup() {
        float width = this.bounds().width();
        float height = this.bounds().height();
        float inputWidth = width - 15.0f - 162.0f;
        this.textName = this.addTextField(5.0f, 15.0f, inputWidth, 12.0f, "enterName");
        this.textName.setMaxLength(80);
        this.textTags = this.addTextField(5.0f, 45.0f, inputWidth, 12.0f, "enterTags");
        this.textTags.setMaxLength(32);
        this.textDescription = this.addTextView(5.0f, 75.0f, inputWidth, height - 75.0f - 40.0f, "enterDescription");
        this.textDescription.setAutoresizingMask(18);
        this.textDescription.setMaxLength(255);
        this.addLabel(5.0f, 5.0f, inputWidth, 10.0f, this.getDisplayText("skinName", new Object[0]));
        this.addLabel(5.0f, 35.0f, inputWidth, 10.0f, this.getDisplayText("skinTags", new Object[0]));
        this.addLabel(5.0f, 65.0f, inputWidth, 10.0f, this.getDisplayText("skinDescription", new Object[0]));
        this.buttonUpdate = this.addTextButton(5.0f, height - 25.0f, 100.0f, 20.0f, "buttonUpdate", SkinEditLibraryPanel::updateSkin);
        this.buttonUpdate.setAutoresizingMask(12);
        this.buttonDelete = this.addTextButton(width - 105.0f, height - 25.0f, 100.0f, 20.0f, "buttonDelete", SkinEditLibraryPanel::removeSkinPre);
        this.buttonDelete.setAutoresizingMask(9);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.textName != null) {
            this.buttonUpdate.setEnabled(Strings.isNotBlank((String)this.textName.text()));
        }
    }

    public void reloadData(ServerSkin entry, GlobalSkinLibraryWindow.Page returnPage) {
        this.entry = entry;
        this.returnPage = returnPage;
        this.textName.setText(entry.name());
        this.textDescription.setText(entry.description());
        this.textTags.setText("");
    }

    private void updateSkin(UIControl button) {
        String name = this.textName.text().trim();
        String description = this.textDescription.text().trim();
        if (name.isEmpty()) {
            ModLog.warn("Can't set the skin name to empty", new Object[0]);
            return;
        }
        if (name.equals(this.entry.name()) && description.equals(this.entry.description())) {
            this.backToPage(false);
            return;
        }
        this.buttonUpdate.setEnabled(false);
        this.entry.update(name, description, (result, exception) -> {
            this.buttonUpdate.setEnabled(true);
            if (exception == null) {
                this.backToPage(false);
            }
        });
    }

    private void removeSkinPre(UIControl button) {
        ConfirmDialog dialog = new ConfirmDialog();
        dialog.setTitle(this.getDisplayText("dialog.delete.title", new Object[0]));
        dialog.setMessageColor(UIColor.of(-43691));
        dialog.setConfirmText(this.getDisplayText("dialog.delete.ok", new Object[0]));
        dialog.setCancelText(this.getDisplayText("dialog.delete.cancel", new Object[0]));
        dialog.setMessage(this.getDisplayText("dialog.delete.message", this.entry.name()));
        dialog.showInView(this, () -> {
            if (!dialog.isCancelled()) {
                this.removeSkin(button);
            }
        });
    }

    private void removeSkin(UIControl button) {
        this.entry.remove((result, exception) -> {
            if (exception == null) {
                this.backToPage(true);
            }
        });
    }

    private void backToPage(boolean removed) {
        if (removed) {
            this.router.skinDidChange(this.entry.id(), null);
        } else {
            this.router.skinDidChange(this.entry.id(), this.entry);
        }
        this.router.showPage(this.returnPage);
    }

    private UITextField addTextField(float x, float y, float width, float height, String key) {
        UITextField textField = new UITextField(new CGRect(x, y, width, height));
        textField.setPlaceholder(this.getDisplayText(key, new Object[0]));
        textField.setMaxLength(255);
        textField.setAutoresizingMask(2);
        this.addSubview(textField);
        return textField;
    }

    private UITextView addTextView(float x, float y, float width, float height, String key) {
        UITextView textField = new UITextView(new CGRect(x, y, width, height));
        textField.setPlaceholder(this.getDisplayText(key, new Object[0]));
        textField.setMaxLength(255);
        this.addSubview(textField);
        return textField;
    }

    protected UILabel addLabel(float x, float y, float width, float height, NSString message) {
        UILabel label = new UILabel(new CGRect(x, y, width, height));
        label.setText(message);
        label.setTextColor(UIColor.WHITE);
        label.setAutoresizingMask(2);
        this.addSubview(label);
        return label;
    }

    private UIButton addTextButton(float x, float y, float width, float height, String key, BiConsumer<SkinEditLibraryPanel, UIControl> handler) {
        UIButton button = new UIButton(new CGRect(x, y, width, height));
        button.setTitle(this.getDisplayText(key, new Object[0]), 0);
        button.setTitleColor(UIColor.WHITE, 0);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, handler);
        this.addSubview(button);
        return button;
    }
}

