/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.skinlibrary;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UITextField;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.data.DataEncryptMethod;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileOptions;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModMenuOptions;
import net.minecraft.class_2487;

public class SkinLibrarySettingWindow
extends ConfirmDialog {
    private static SkinProperties OPTIONS;
    private int contentHeight = 24;
    private final SkinProperties properties = SkinLibrarySettingWindow.getChanges().copy();

    public SkinLibrarySettingWindow() {
        this.setup();
        this.contentHeight += 6;
    }

    public static boolean hasChanges() {
        return !SkinLibrarySettingWindow.getChanges().isEmpty();
    }

    public static void setChanges(SkinProperties properties) {
        SkinProperties newProperties = properties.copy();
        ModMenuOptions.getInstance().putTag("library.fileOptions", newProperties.serializeNBT());
        OPTIONS = newProperties;
    }

    public static SkinProperties getChanges() {
        if (OPTIONS == null) {
            class_2487 tag = ModMenuOptions.getInstance().getTag("library.fileOptions");
            OPTIONS = tag != null ? new SkinProperties(tag) : new SkinProperties();
        }
        return OPTIONS;
    }

    public static SkinFileOptions getFileOptions() {
        SkinProperties values = SkinLibrarySettingWindow.getChanges().copy();
        SkinFileOptions options = new SkinFileOptions();
        options.setEditable(values.get(Option.IS_EDITABLE));
        options.setSavable(values.get(Option.IS_SAVABLE));
        options.setExportable(values.get(Option.IS_EXPORTABLE));
        options.setEncrypted(false);
        options.setCompressed(values.get(Option.IS_COMPRESSED));
        if (values.get(Option.IS_ENCRYPTED).booleanValue()) {
            Integer selectedIndex = values.get(Option.ENCRYPTED_MODE);
            DataEncryptMethod[] algorithms = DataEncryptMethod.values();
            DataEncryptMethod algorithm = algorithms[selectedIndex % algorithms.length];
            String key = algorithm.key(values.get(Option.ENCRYPTED_KEY));
            String signature = algorithm.signature(key);
            options.setSecurityData(signature);
            options.setSecurityKey(key);
        } else {
            values.remove(Option.ENCRYPTED_MODE);
            values.remove(Option.ENCRYPTED_KEY);
        }
        if (!values.isEmpty()) {
            options.setFileVersion(25);
        }
        return options;
    }

    private void setup() {
        this.messageLabel.removeFromSuperview();
        this.addOptionView(Option.NEW_FORMAT_MODE);
        this.addOptionView(Option.IS_EDITABLE);
        this.addOptionView(Option.IS_SAVABLE);
        this.addOptionView(Option.IS_EXPORTABLE);
        this.addOptionView(Option.IS_COMPRESSED);
        this.addOptionView(Option.IS_ENCRYPTED);
        this.addEncryptView();
    }

    private UICheckBox addOptionView(Option<Boolean> property) {
        UICheckBox checkBox = new UICheckBox(new CGRect(8.0f, this.contentHeight, this.bounds().width() - 16.0f, 9.0f));
        checkBox.setTitle(NSString.localizedString("skin-library.setting." + property.key(), new Object[0]));
        checkBox.setSelected(this.properties.get(property));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, sender) -> this.properties.put(property, sender.isSelected()));
        checkBox.setAutoresizingMask(34);
        this.addSubview(checkBox);
        this.contentHeight += 13;
        return checkBox;
    }

    private void addEncryptView() {
        ArrayList<String> modes = Collections.compactMap(DataEncryptMethod.values(), it -> it.method() + "Mode");
        int defaultSelectedIndex = this.properties.get(Option.ENCRYPTED_MODE);
        if (defaultSelectedIndex >= modes.size()) {
            defaultSelectedIndex = 0;
        }
        float width = this.bounds().width();
        UIComboBox comboBox = new UIComboBox(new CGRect(16.0f, this.contentHeight, 80.0f, 20.0f));
        UITextField textBox = new UITextField(new CGRect(104.0f, this.contentHeight, width - 104.0f - 16.0f, 20.0f));
        comboBox.setSelectedIndex(defaultSelectedIndex);
        comboBox.reloadData(Collections.compactMap(modes, it -> new UIComboItem(NSString.localizedString("skin-library.setting." + it, new Object[0]))));
        comboBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, sender) -> {
            int selectedIndex1 = comboBox.selectedIndex();
            this.properties.put(Option.ENCRYPTED_MODE, selectedIndex1);
            textBox.setText("");
            textBox.setPlaceholder(NSString.localizedString("skin-library.setting." + (String)modes.get(selectedIndex1) + ".enterText", new Object[0]));
        });
        this.addSubview(comboBox);
        textBox.setText(this.properties.get(Option.ENCRYPTED_KEY));
        textBox.setPlaceholder(NSString.localizedString("skin-library.setting." + modes.get(defaultSelectedIndex) + ".enterText", new Object[0]));
        textBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, sender) -> this.properties.put(Option.ENCRYPTED_KEY, textBox.text()));
        this.addSubview(textBox);
        this.contentHeight += 24;
    }

    @Override
    public void sizeToFit() {
        this.setBounds(new CGRect(0.0f, 0.0f, this.bounds().width(), this.contentHeight + 30));
    }

    public SkinProperties getProperties() {
        return this.properties;
    }

    public static class Option<T>
    extends SkinProperty<T> {
        public static final Option<Boolean> NEW_FORMAT_MODE = Option.normal("newFormatMode", false);
        public static final Option<Boolean> IS_EDITABLE = Option.normal("isEditable", true);
        public static final Option<Boolean> IS_SAVABLE = Option.normal("isSavable", true);
        public static final Option<Boolean> IS_EXPORTABLE = Option.normal("isExportable", true);
        public static final Option<Boolean> IS_COMPRESSED = Option.normal("isCompressed", false);
        public static final Option<Boolean> IS_ENCRYPTED = Option.normal("isEncrypted", false);
        public static final Option<Integer> ENCRYPTED_MODE = Option.normal("encryptedMode", 0);
        public static final Option<String> ENCRYPTED_KEY = Option.normal("encryptedKey", "");

        public Option(String key, T defaultValue) {
            super(key, defaultValue, false);
        }

        public static <T> Option<T> normal(String key, T defaultValue) {
            return new Option<T>(key, defaultValue);
        }
    }
}

