/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass.model;

import dev.ultimatchamp.bettergrass.config.BetterGrassifyConfig;
import dev.ultimatchamp.bettergrass.util.SpriteCalculator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class BetterGrassifyBakedModel
extends ForwardingBakedModel {
    public BetterGrassifyBakedModel(class_1087 baseModel) {
        this.wrapped = baseModel;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.pushTransform(quad -> {
            switch (BetterGrassifyConfig.load().betterGrassMode) {
                case OFF: {
                    break;
                }
                case FAST: {
                    if (quad.nominalFace().method_10166() == class_2350.class_2351.field_11052 || !BetterGrassifyBakedModel.isFullQuad(quad)) break;
                    if (state.method_26204().equals(class_2246.field_10566)) {
                        if (BetterGrassifyBakedModel.isBelowNonFullBlock(blockView, pos, quad.nominalFace())) {
                            BetterGrassifyBakedModel.dirtSpriteBake(quad, blockView, pos, randomSupplier);
                            break;
                        }
                    } else {
                        if (BetterGrassifyBakedModel.isSnowy(blockView, pos)) {
                            BetterGrassifyBakedModel.spriteBake(quad, blockView.method_8320(pos.method_10084()), randomSupplier);
                            break;
                        }
                        if (BetterGrassifyBakedModel.canHaveSnowLayer(blockView, pos.method_10084()) && BetterGrassifyBakedModel.isNeighbourSnow(blockView, pos.method_10084())) {
                            BetterGrassifyBakedModel.spriteBake(quad, BetterGrassifyBakedModel.snowNeighbour(blockView, pos.method_10084()).method_9564(), randomSupplier);
                            break;
                        }
                    }
                    BetterGrassifyBakedModel.spriteBake(quad, blockView.method_8320(pos), randomSupplier);
                    break;
                }
                case FANCY: {
                    if (quad.nominalFace().method_10166() == class_2350.class_2351.field_11052 || !BetterGrassifyBakedModel.isFullQuad(quad)) break;
                    class_2350 face = quad.nominalFace();
                    if (state.method_26204().equals(class_2246.field_10566)) {
                        if (!BetterGrassifyBakedModel.isBelowNonFullBlock(blockView, pos, quad.nominalFace())) break;
                        BetterGrassifyBakedModel.dirtSpriteBake(quad, blockView, pos, randomSupplier);
                        break;
                    }
                    if (BetterGrassifyBakedModel.canFullyConnect(blockView, state, pos, face)) {
                        if (BetterGrassifyBakedModel.isSnowy(blockView, pos)) {
                            BetterGrassifyBakedModel.spriteBake(quad, blockView.method_8320(pos.method_10084()), randomSupplier);
                            break;
                        }
                        BetterGrassifyBakedModel.spriteBake(quad, state, randomSupplier);
                        break;
                    }
                    if (BetterGrassifyBakedModel.isSnowy(blockView, pos) && BetterGrassifyBakedModel.canHaveSnowLayer(blockView, pos.method_10093(face)) && BetterGrassifyBakedModel.isNeighbourSnow(blockView, pos.method_10093(face))) {
                        BetterGrassifyBakedModel.spriteBake(quad, blockView.method_8320(pos.method_10084()), randomSupplier);
                        break;
                    }
                    if (BetterGrassifyBakedModel.canHaveSnowLayer(blockView, pos.method_10084()) && BetterGrassifyBakedModel.isNeighbourSnow(blockView, pos.method_10084()) && BetterGrassifyBakedModel.isSnowy(blockView, pos.method_10093(face).method_10074())) {
                        BetterGrassifyBakedModel.spriteBake(quad, blockView.method_8320(pos.method_10093(face)), randomSupplier);
                        break;
                    }
                    if (!BetterGrassifyBakedModel.canHaveSnowLayer(blockView, pos.method_10084()) || !BetterGrassifyBakedModel.isNeighbourSnow(blockView, pos.method_10084()) || !BetterGrassifyBakedModel.canHaveSnowLayer(blockView, pos.method_10093(face))) break;
                    BetterGrassifyBakedModel.spriteBake(quad, BetterGrassifyBakedModel.snowNeighbour(blockView, pos.method_10084()).method_9564(), randomSupplier);
                }
            }
            return true;
        });
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    private static boolean isFullQuad(MutableQuadView quad) {
        if (!BetterGrassifyConfig.load().resourcePackCompatibilityMode) {
            return true;
        }
        double tolerance = 0.0625;
        for (int i = 0; i < 4; ++i) {
            float y = quad.y(i);
            if (!((double)Math.abs(y - (float)Math.round(y)) > tolerance)) continue;
            return false;
        }
        return true;
    }

    private static boolean canFullyConnect(class_1920 world, class_2680 self, class_2338 selfPos, class_2350 direction) {
        return BetterGrassifyBakedModel.canConnect(world, self, selfPos, selfPos.method_10093(direction).method_10074());
    }

    private static boolean canConnect(class_1920 world, class_2680 self, class_2338 selfPos, class_2338 adjacentPos) {
        class_2680 adjacent = world.method_8320(adjacentPos);
        class_2338 upPos = adjacentPos.method_10084();
        class_2680 up = world.method_8320(upPos);
        return BetterGrassifyBakedModel.canConnect(self, adjacent) && (up.method_26215() || BetterGrassifyBakedModel.isSnowy(world, selfPos) || !up.method_26206((class_1922)world, upPos, class_2350.field_11033));
    }

    private static boolean canConnect(class_2680 self, class_2680 adjacent) {
        return self == adjacent;
    }

    private static boolean isBelowNonFullBlock(class_1920 world, class_2338 selfPos, class_2350 direction) {
        class_2338 upPos = selfPos.method_10084();
        class_2680 up = world.method_8320(upPos);
        if (up.method_26204().equals(class_2246.field_10194) && !BetterGrassifyConfig.load().dirtPaths) {
            return false;
        }
        if (up.method_26204().equals(class_2246.field_10362) && !BetterGrassifyConfig.load().farmLands) {
            return false;
        }
        if (!up.method_26204().equals(class_2246.field_10194) && !up.method_26204().equals(class_2246.field_10362)) {
            return false;
        }
        return BetterGrassifyBakedModel.canFullyConnect(world, up, upPos, direction);
    }

    private static boolean isSnowy(class_1920 world, class_2338 selfPos) {
        class_2680 self = world.method_8320(selfPos);
        return self.method_28500((class_2769)class_2741.field_12512).orElse(false) != false && !world.method_8320(selfPos.method_10084()).method_26215();
    }

    public static class_2248 snowNeighbour(class_1920 world, class_2338 selfPos) {
        for (String id : BetterGrassifyConfig.load().snowLayers) {
            boolean layerCheck;
            class_2960 identifier = class_2960.method_12829((String)id);
            Optional layer = class_7923.field_41175.method_17966(identifier);
            if (layer.isEmpty()) continue;
            List<class_2338> directions = List.of(selfPos.method_10095(), selfPos.method_10072(), selfPos.method_10078(), selfPos.method_10067());
            boolean[] isSnow = new boolean[4];
            for (class_2338 direction : directions) {
                isSnow[directions.indexOf((Object)direction)] = world.method_8320(direction).method_27852((class_2248)layer.get()) || id.equals("snow") && (world.method_8320(direction).method_27852(class_2246.field_10491) || world.method_8320(direction).method_27852(class_2246.field_27879));
            }
            if (!(layerCheck = (switch (BetterGrassifyConfig.load().betterSnowMode) {
                case BetterGrassifyConfig.BetterSnowMode.OPTIFINE -> {
                    if (isSnow[0] || isSnow[1] || isSnow[2] || isSnow[3]) {
                        yield true;
                    }
                    yield false;
                }
                case BetterGrassifyConfig.BetterSnowMode.LAMBDA -> {
                    if ((isSnow[0] || isSnow[1]) && (isSnow[2] || isSnow[3]) || isSnow[0] && isSnow[1] || isSnow[2] && isSnow[3]) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            }))) continue;
            return (class_2248)layer.get();
        }
        return null;
    }

    public static boolean isNeighbourSnow(class_1920 world, class_2338 selfPos) {
        return BetterGrassifyBakedModel.snowNeighbour(world, selfPos) == class_2246.field_10477;
    }

    public static boolean canHaveSnowLayer(class_1920 world, class_2338 selfPos) {
        if (BetterGrassifyConfig.load().betterSnowMode == BetterGrassifyConfig.BetterSnowMode.OFF) {
            return false;
        }
        class_2680 self = world.method_8320(selfPos);
        boolean isLayer = BetterGrassifyBakedModel.snowNeighbour(world, selfPos) != null;
        boolean isExcludedBlock = false;
        if (BetterGrassifyConfig.load().whitelistedTags.isEmpty() && BetterGrassifyConfig.load().whitelistedBlocks.isEmpty()) {
            for (String block : BetterGrassifyConfig.load().excludedBlocks) {
                hasAttribute = block.contains("[");
                withoutAttribute = block;
                attribute = "";
                attributeEnabled = true;
                if (hasAttribute) {
                    withoutAttribute = block.substring(0, block.indexOf("["));
                    attribute = block.contains("=") ? block.substring(block.indexOf("[") + 1, block.indexOf("=")) : block.substring(block.indexOf("[") + 1, block.indexOf("]"));
                    boolean bl = attributeEnabled = !block.contains("=false");
                }
                if ((blockCheck = class_7923.field_41175.method_17966(identifier = class_2960.method_12829((String)withoutAttribute))).isEmpty() || !self.method_26204().equals(blockCheck.get())) continue;
                if (hasAttribute) {
                    if (!self.toString().contains(attribute + "=" + attributeEnabled)) continue;
                    isExcludedBlock = true;
                    continue;
                }
                isExcludedBlock = true;
            }
        } else {
            isExcludedBlock = true;
            for (String block : BetterGrassifyConfig.load().whitelistedBlocks) {
                hasAttribute = block.contains("[");
                withoutAttribute = block;
                attribute = "";
                attributeEnabled = true;
                if (hasAttribute) {
                    withoutAttribute = block.substring(0, block.indexOf("["));
                    attribute = block.contains("=") ? block.substring(block.indexOf("[") + 1, block.indexOf("=")) : block.substring(block.indexOf("[") + 1, block.indexOf("]"));
                    boolean bl = attributeEnabled = !block.contains("=false");
                }
                if ((blockCheck = class_7923.field_41175.method_17966(identifier = class_2960.method_12829((String)withoutAttribute))).isEmpty() || !self.method_26204().equals(blockCheck.get())) continue;
                if (hasAttribute) {
                    if (!self.toString().contains(attribute + "=" + attributeEnabled)) continue;
                    isExcludedBlock = false;
                    continue;
                }
                isExcludedBlock = false;
            }
        }
        boolean isExcludedTag = false;
        if (BetterGrassifyConfig.load().whitelistedTags.isEmpty() && BetterGrassifyConfig.load().whitelistedBlocks.isEmpty()) {
            for (String tag : BetterGrassifyConfig.load().excludedTags) {
                identifier = class_2960.method_12829((String)tag);
                tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)identifier);
                if (!self.method_26164(tagKey)) continue;
                isExcludedTag = true;
            }
        } else {
            isExcludedTag = true;
            for (String tag : BetterGrassifyConfig.load().whitelistedTags) {
                identifier = class_2960.method_12829((String)tag);
                tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)identifier);
                if (!self.method_26164(tagKey)) continue;
                isExcludedTag = false;
                isExcludedBlock = false;
            }
            if (!isExcludedBlock) {
                isExcludedTag = false;
            }
        }
        return isLayer && !self.method_26215() && !self.method_27852(class_2246.field_10382) && !self.method_26206((class_1922)world, selfPos, class_2350.field_11033) && world.method_8320(selfPos.method_10074()).method_26216((class_1922)world, selfPos.method_10074()) && !isExcludedTag && !isExcludedBlock;
    }

    private static void spriteBake(MutableQuadView quad, class_2680 state, Supplier<class_5819> randomSupplier) {
        class_1058 sprite = SpriteCalculator.calculateSprite(state, class_2350.field_11036, randomSupplier);
        if (sprite != null) {
            quad.spriteBake(sprite, 4);
        }
    }

    private static void dirtSpriteBake(MutableQuadView quad, class_1920 world, class_2338 selfPos, Supplier<class_5819> randomSupplier) {
        class_2338 upPos = selfPos.method_10084();
        class_2680 up = world.method_8320(upPos);
        class_1058 sprite = SpriteCalculator.calculateSprite(up, class_2350.field_11036, randomSupplier);
        if (sprite != null) {
            quad.spriteBake(sprite, 4);
        }
    }
}

