/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.item;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2495;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.teacon.slides.Slideshow;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.util.RegistryClient;
import org.teacon.slides.util.Utilities;

public class FlipperItem
extends class_1792 {
    private static boolean attackKeyDown = false;

    public FlipperItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static int[] getProjectorPos(class_1799 stack) {
        if (!stack.method_31574(Slideshow.FLIPPER_ITEM) || !stack.method_7985() || stack.method_7969().method_10561("projector") == null) {
            return null;
        }
        int[] intArray = stack.method_7969().method_10561("projector");
        if (intArray == null || intArray.length < 3) {
            return null;
        }
        return intArray;
    }

    public static void setProjectorPos(class_1799 stack, @Nullable class_2338 pos) {
        if (!stack.method_31574(Slideshow.FLIPPER_ITEM)) {
            return;
        }
        if (pos == null) {
            stack.method_7983("projector");
            return;
        }
        stack.method_7959("projector", (class_2520)new class_2495(new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}));
    }

    public static boolean trySendFlip(class_1937 world, class_3222 player, class_1799 itemStack, boolean back, boolean init) {
        int[] pos = FlipperItem.getProjectorPos(itemStack);
        if (pos == null) {
            Utilities.sendOverLayMessage((class_1657)player, (class_2561)class_2561.method_43471((String)"info.slide_show.need_bound").method_27692(class_124.field_1079));
            return false;
        }
        class_2586 entity = world.method_8321(new class_2338(pos[0], pos[1], pos[2]));
        if (!(entity instanceof ProjectorBlockEntity)) {
            Utilities.sendOverLayMessage((class_1657)player, (class_2561)class_2561.method_43471((String)"info.slide_show.binding_lost").method_27692(class_124.field_1079));
            FlipperItem.setProjectorPos(itemStack, null);
            return false;
        }
        ProjectorBlockEntity entity1 = (ProjectorBlockEntity)entity;
        if (!FlipperItem.hasFlipperPermission(player)) {
            return false;
        }
        if (!entity1.canFlip()) {
            return false;
        }
        if (init) {
            entity1.needInitContainer = true;
            Utilities.sendOverLayMessage((class_1657)player, (class_2561)class_2561.method_43471((String)"info.slide_show.initialized").method_27692(class_124.field_1075));
            return true;
        }
        entity1.needHandleReadImage = true;
        if (back) {
            entity1.flipBack = true;
        }
        Utilities.sendOverLayMessage((class_1657)player, (class_2561)class_2561.method_43471((String)"info.slide_show.slide_flipped").method_27692(class_124.field_1075));
        return true;
    }

    private static boolean hasFlipperPermission(class_3222 player) {
        return player.method_7337() || player.field_13974.method_14257() == class_1934.field_9215;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (world.method_8608()) {
            return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
        }
        if (FlipperItem.trySendFlip(world, (class_3222)player, itemStack, false, player.method_5715())) {
            return class_1271.method_29237((Object)itemStack, (boolean)true);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7888(class_1799 itemStack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(itemStack, world, entity, slot, selected);
        if (world.method_8608() && selected && attackKeyDown != class_310.method_1551().field_1690.field_1886.method_1434()) {
            boolean bl = attackKeyDown = !attackKeyDown;
            if (attackKeyDown) {
                FlipperItem.sendServerFlipBack(slot);
            }
        }
    }

    public void method_7851(class_1799 itemStack, @Nullable class_1937 world, List<class_2561> list, class_1836 tooltipFlag) {
        int[] pos = FlipperItem.getProjectorPos(itemStack);
        if (pos == null) {
            list.add((class_2561)class_2561.method_43471((String)"item.slide_show.flipper.tooltip.not_bound").method_27692(class_124.field_1061));
            list.add((class_2561)class_2561.method_43471((String)"item.slide_show.flipper.tooltip.not_bound1"));
            super.method_7851(itemStack, world, list, tooltipFlag);
            return;
        }
        list.add((class_2561)class_2561.method_43469((String)"item.slide_show.flipper.tooltip.bound", (Object[])new Object[]{pos[0], pos[1], pos[2]}).method_27692(class_124.field_1075));
        super.method_7851(itemStack, world, list, tooltipFlag);
    }

    private static void sendServerFlipBack(int i) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeInt(i);
        RegistryClient.sendToServer(Slideshow.PACKET_FLIP_BACK, buffer);
    }

    public static void handleServerFlipBack(MinecraftServer minecraftServer, class_3222 serverPlayer, class_2540 packet) {
        int i = packet.readInt();
        minecraftServer.execute(() -> {
            class_1799 itemStack = serverPlayer.method_31548().method_5438(i);
            if (itemStack.method_31574(Slideshow.FLIPPER_ITEM) && FlipperItem.trySendFlip((class_1937)serverPlayer.method_51469(), serverPlayer, itemStack, true, false)) {
                GameProfile profile = serverPlayer.method_7334();
                Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for flip back: player = {}", (Object)profile);
            }
        });
    }

    public boolean method_7885(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 player) {
        return false;
    }
}

