/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import java.util.Arrays;
import java.util.Locale;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.teacon.slides.Slideshow;
import org.teacon.slides.item.FlipperItem;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.util.Utilities;

public final class ProjectorBlock
extends class_2237 {
    public static final class_2754<InternalRotation> ROTATION = class_2754.method_11850((String)"rotation", InternalRotation.class);
    public static final class_2754<class_2350> BASE = class_2754.method_11848((String)"base", class_2350.class, (Predicate)class_2350.class_2353.field_11064);
    private static final class_265 SHAPE_WITH_BASE_UP = class_2248.method_9541((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SHAPE_WITH_BASE_DOWN = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ProjectorBlock() {
        super((class_4970.class_2251)FabricBlockSettings.of().sounds(class_2498.field_11533).strength(20.0f).luminance(state -> 15).noCollision());
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(BASE, (Comparable)class_2350.field_11033)).method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11034)).method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.FALSE)).method_11657(ROTATION, (Comparable)((Object)InternalRotation.NONE)));
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654(BASE)) {
            case class_2350.field_11033 -> SHAPE_WITH_BASE_DOWN;
            case class_2350.field_11036 -> SHAPE_WITH_BASE_UP;
            default -> throw new AssertionError();
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{BASE, class_2741.field_12525, class_2741.field_12484, ROTATION});
    }

    @NotNull
    public class_2680 method_9605(class_1750 context) {
        class_2350 facing = context.method_7715().method_10153();
        class_2350 horizontalFacing = context.method_32760().method_10153();
        class_2350 base = Arrays.stream(context.method_7718()).filter((Predicate<class_2350>)class_2350.class_2353.field_11064).findFirst().orElse(class_2350.field_11033);
        InternalRotation rotation = InternalRotation.VALUES[4 + Math.floorMod(facing.method_10164() * horizontalFacing.method_10161(), 4)];
        return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(BASE, (Comparable)base)).method_11657((class_2769)class_2741.field_12525, (Comparable)facing)).method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.FALSE)).method_11657(ROTATION, (Comparable)((Object)rotation));
    }

    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        boolean powered = worldIn.method_49803(pos);
        if (powered != (Boolean)state.method_11654((class_2769)class_2741.field_12484)) {
            worldIn.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(powered)));
        }
    }

    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        boolean powered;
        if (!oldState.method_27852(state.method_26204()) && (powered = worldIn.method_49803(pos)) != (Boolean)state.method_11654((class_2769)class_2741.field_12484)) {
            worldIn.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(powered)));
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : ProjectorBlock.method_31618(type, Slideshow.PROJECTOR_BLOCK_ENTITY, (world1, pos, state1, entity) -> ProjectorBlockEntity.tick(world1, pos, entity));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        return switch (direction) {
            case class_2350.field_11033, class_2350.field_11036 -> (class_2680)state.method_11657(ROTATION, (Comparable)((Object)((InternalRotation)((Object)state.method_11654(ROTATION))).compose(class_2470.field_11464)));
            default -> (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)mirror.method_10345(direction).method_10503(direction));
        };
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        return switch (direction) {
            case class_2350.field_11033, class_2350.field_11036 -> (class_2680)state.method_11657(ROTATION, (Comparable)((Object)((InternalRotation)((Object)state.method_11654(ROTATION))).compose(rotation)));
            default -> (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)rotation.method_10503(direction));
        };
    }

    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.method_8608()) {
            if (!ProjectorBlock.hasProjectorPermission((class_3222)player)) {
                return class_1269.field_5814;
            }
            class_1799 itemStack = player.method_5998(hand);
            if (itemStack.method_31574(Slideshow.FLIPPER_ITEM)) {
                FlipperItem.setProjectorPos(itemStack, pos);
                Utilities.sendOverLayMessage(player, (class_2561)class_2561.method_43471((String)"info.slide_show.bound_projector").method_27692(class_124.field_1075));
                return class_1269.field_21466;
            }
            class_3908 factory = this.method_17454(state, world, pos);
            if (factory != null) {
                player.method_17355(factory);
            }
        }
        return class_1269.field_5812;
    }

    public static boolean hasProjectorPermission(class_3222 serverPlayer) {
        return serverPlayer.method_7338();
    }

    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    private static boolean hasPermission(class_1934 gameType) {
        return gameType == class_1934.field_9220 || gameType == class_1934.field_9215;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ProjectorBlockEntity(pos, state);
    }

    public static enum InternalRotation implements class_3542
    {
        NONE(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f),
        CLOCKWISE_90(0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f),
        CLOCKWISE_180(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f),
        COUNTERCLOCKWISE_90(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f),
        HORIZONTAL_FLIPPED(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f),
        DIAGONAL_FLIPPED(0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f),
        VERTICAL_FLIPPED(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f),
        ANTI_DIAGONAL_FLIPPED(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);

        public static final InternalRotation[] VALUES;
        private static final int[] INV_INDICES;
        private static final int[] FLIP_INDICES;
        private static final int[][] ROTATION_INDICES;
        private final String mSerializedName;
        private final Matrix4f mMatrix;
        private final Matrix3f mNormal;

        private InternalRotation(float m00, float m10, float m20, float m30, float m01, float m11, float m21, float m31, float m02, float m12, float m22, float m32) {
            this.mMatrix = new Matrix4f(m00, m01, m02, 0.0f, m10, m11, m12, 0.0f, m20, m21, m22, 0.0f, m30, m31, m32, 1.0f);
            this.mNormal = new Matrix3f(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            this.mSerializedName = this.name().toLowerCase(Locale.ROOT);
        }

        public InternalRotation compose(class_2470 rotation) {
            return VALUES[ROTATION_INDICES[rotation.ordinal()][this.ordinal()]];
        }

        public InternalRotation flip() {
            return VALUES[FLIP_INDICES[this.ordinal()]];
        }

        public InternalRotation invert() {
            return VALUES[INV_INDICES[this.ordinal()]];
        }

        public boolean isFlipped() {
            return this.ordinal() >= 4;
        }

        public void transform(Vector4f vector) {
            vector.mul((Matrix4fc)this.mMatrix);
        }

        public void transform(Matrix4f poseMatrix) {
            poseMatrix.mul((Matrix4fc)this.mMatrix);
        }

        public void transform(Matrix3f normalMatrix) {
            normalMatrix.mul((Matrix3fc)this.mNormal);
        }

        @NotNull
        public final String method_15434() {
            return this.mSerializedName;
        }

        static {
            VALUES = InternalRotation.values();
            INV_INDICES = new int[]{0, 3, 2, 1, 4, 5, 6, 7};
            FLIP_INDICES = new int[]{4, 7, 6, 5, 0, 3, 2, 1};
            ROTATION_INDICES = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 0, 5, 6, 7, 4}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 0, 1, 2, 7, 4, 5, 6}};
        }
    }
}

