/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.network.serialization;

import com.google.common.collect.ImmutableMap;
import io.wispforest.owo.Owo;
import io.wispforest.owo.network.serialization.PacketBufSerializer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.class_2540;

public final class RecordSerializer<R extends Record> {
    private static final Map<Class<?>, RecordSerializer<?>> SERIALIZERS = new HashMap();
    private final Map<Function<R, ?>, PacketBufSerializer> adapters;
    private final Class<R> recordClass;
    private final Constructor<R> instanceCreator;
    private final int fieldCount;

    private RecordSerializer(Class<R> recordClass, Constructor<R> instanceCreator, ImmutableMap<Function<R, ?>, PacketBufSerializer> adapters) {
        this.recordClass = recordClass;
        this.instanceCreator = instanceCreator;
        this.adapters = adapters;
        this.fieldCount = recordClass.getRecordComponents().length;
    }

    public static <R extends Record> RecordSerializer<R> create(Class<R> recordClass) {
        if (SERIALIZERS.containsKey(recordClass)) {
            return SERIALIZERS.get(recordClass);
        }
        ImmutableMap.Builder adapters = new ImmutableMap.Builder();
        Class[] canonicalConstructorArgs = new Class[recordClass.getRecordComponents().length];
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        for (int i = 0; i < recordClass.getRecordComponents().length; ++i) {
            try {
                RecordComponent component = recordClass.getRecordComponents()[i];
                MethodHandle handle = lookup.unreflect(component.getAccessor());
                adapters.put(r -> RecordSerializer.getRecordEntry(r, handle), PacketBufSerializer.getGeneric(component.getGenericType()));
                canonicalConstructorArgs[i] = component.getType();
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not create method handle for record component");
            }
        }
        try {
            RecordSerializer<R> serializer = new RecordSerializer<R>(recordClass, recordClass.getConstructor(canonicalConstructorArgs), adapters.build());
            SERIALIZERS.put(recordClass, serializer);
            return serializer;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not locate canonical record constructor");
        }
    }

    public R read(class_2540 buffer) {
        Object[] messageContents = new Object[this.fieldCount];
        AtomicInteger index = new AtomicInteger();
        this.adapters.forEach((rFunction, typeAdapter) -> {
            messageContents[index.getAndIncrement()] = typeAdapter.deserializer().apply((Object)buffer);
        });
        try {
            return (R)((Record)this.instanceCreator.newInstance(messageContents));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Owo.LOGGER.error("Error while deserializing record", (Throwable)e);
            return null;
        }
    }

    public RecordSerializer<R> write(class_2540 buffer, R instance) {
        this.adapters.forEach((rFunction, typeAdapter) -> typeAdapter.serializer().accept((Object)buffer, rFunction.apply(instance)));
        return this;
    }

    public Class<R> getRecordClass() {
        return this.recordClass;
    }

    private static <R extends Record> Object getRecordEntry(R instance, MethodHandle accessor) {
        try {
            return accessor.invoke(instance);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to get record component value", e);
        }
    }
}

