/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mc.euphoria_patches.euphoria_patcher.features.UpdateShaderLoaderConfig;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class Dimensions {
    public static final String SHADER_DIMENSION_PROPERTIES_LOCATION = "shaders/dimension.properties";

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[Dimensions] " + message);
    }

    public static String getCurrentDimension(String currentDimensionId) {
        if (currentDimensionId == null) {
            Dimensions.debugLog("Dimension ID is null, defaulting to 'overworld'");
            return "overworld";
        }
        Path shaderpackPath = UpdateShaderLoaderConfig.getCurrentShaderpackPath();
        if (shaderpackPath == null) {
            Dimensions.debugLog("No active shaderpack found");
        } else {
            Dimensions.debugLog("Active shaderpack: " + shaderpackPath.getFileName());
        }
        if (shaderpackPath != null) {
            Map<String, String> dimensionMappings = Dimensions.parseDimensionProperties(shaderpackPath);
            Dimensions.debugLog("Parsed " + dimensionMappings.size() + " dimension mappings from properties file");
            if (dimensionMappings.containsKey(currentDimensionId)) {
                String mappedCategory = dimensionMappings.get(currentDimensionId);
                Dimensions.debugLog("Found mapping for current dimension: " + mappedCategory);
                return mappedCategory;
            }
            Dimensions.debugLog("No specific mapping found for dimension: " + currentDimensionId);
        }
        Dimensions.debugLog("Checking vanilla dimension IDs");
        if (currentDimensionId.equals("minecraft:overworld")) {
            Dimensions.debugLog("Identified as vanilla overworld");
            return "overworld";
        }
        if (currentDimensionId.equals("minecraft:the_nether")) {
            Dimensions.debugLog("Identified as vanilla nether");
            return "nether";
        }
        if (currentDimensionId.equals("minecraft:the_end")) {
            Dimensions.debugLog("Identified as vanilla end");
            return "end";
        }
        Dimensions.debugLog("No mapping found, returning 'other'");
        return "other";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> parseDimensionProperties(Path shaderPackPath) {
        HashMap<String, String> dimensionMap = new HashMap<String, String>();
        if (shaderPackPath == null) {
            Dimensions.debugLog("Shader pack path is null");
            return dimensionMap;
        }
        if (shaderPackPath.toString().endsWith(".zip")) {
            Dimensions.debugLog("Reading from ZIP file: " + shaderPackPath.getFileName());
            try (ZipFile zipFile = new ZipFile(shaderPackPath.toFile());){
                Map<String, String> map;
                ZipEntry entry = zipFile.getEntry(SHADER_DIMENSION_PROPERTIES_LOCATION);
                if (entry == null) {
                    Dimensions.debugLog("dimension.properties not found in ZIP");
                    HashMap<String, String> hashMap = dimensionMap;
                    return hashMap;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry), StandardCharsets.UTF_8));){
                    map = Dimensions.parseDimensionPropertiesFromReader(reader);
                }
                return map;
            }
            catch (IOException e) {
                Dimensions.debugLog("Error reading dimension.properties from ZIP: " + e.getMessage());
            }
        } else {
            Path propertiesFile = shaderPackPath.resolve(SHADER_DIMENSION_PROPERTIES_LOCATION);
            if (Files.exists(propertiesFile, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(propertiesFile, StandardCharsets.UTF_8);){
                    Map<String, String> map = Dimensions.parseDimensionPropertiesFromReader(reader);
                    return map;
                }
                catch (IOException e) {
                    Dimensions.debugLog("Error reading dimension.properties from directory: " + e.getMessage());
                }
            } else {
                Dimensions.debugLog("dimension.properties file not found at path: " + propertiesFile);
            }
        }
        return dimensionMap;
    }

    private static Map<String, String> parseDimensionPropertiesFromReader(BufferedReader reader) throws IOException {
        String line;
        HashMap<String, String> dimensionMap = new HashMap<String, String>();
        StringBuilder currentLine = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
            if (line.endsWith("\\")) {
                currentLine.append(line, 0, line.length() - 1).append(" ");
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(line);
                line = currentLine.toString();
                currentLine.setLength(0);
            }
            if (line.startsWith("dimension.world0=")) {
                Dimensions.addDimensionsToMap(line.substring("dimension.world0=".length()), "overworld", dimensionMap);
                continue;
            }
            if (line.startsWith("dimension.world-1=")) {
                Dimensions.addDimensionsToMap(line.substring("dimension.world-1=".length()), "nether", dimensionMap);
                continue;
            }
            if (!line.startsWith("dimension.world1=")) continue;
            Dimensions.addDimensionsToMap(line.substring("dimension.world1=".length()), "end", dimensionMap);
        }
        return dimensionMap;
    }

    private static void addDimensionsToMap(String dimensionsLine, String targetCategory, Map<String, String> dimensionMap) {
        String[] parts;
        for (String part : parts = dimensionsLine.split("\\s+")) {
            if (part.trim().isEmpty() || part.equals("\\") || part.equals("*")) continue;
            dimensionMap.put(part, targetCategory);
        }
    }
}

