/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.StatsMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

public class ColumnRenderBuffer
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final int QUADS_BYTE_SIZE = LodUtil.LOD_VERTEX_FORMAT.getByteSize() * 4;
    public static final int MAX_VBO_BYTE_SIZE = 0xA00000;
    public static final int MAX_QUADS_PER_BUFFER = 0xA00000 / QUADS_BYTE_SIZE;
    public static final int FULL_SIZED_BUFFER = MAX_QUADS_PER_BUFFER * QUADS_BYTE_SIZE;
    public final DhBlockPos blockPos;
    public boolean buffersUploaded = false;
    private GLVertexBuffer[] vbos;
    private GLVertexBuffer[] vbosTransparent;
    private CompletableFuture<ColumnRenderBuffer> uploadFuture = null;

    public ColumnRenderBuffer(DhBlockPos blockPos) {
        this.blockPos = blockPos;
        this.vbos = new GLVertexBuffer[0];
        this.vbosTransparent = new GLVertexBuffer[0];
    }

    public synchronized CompletableFuture<ColumnRenderBuffer> makeAndUploadBuffersAsync(LodQuadBuilder builder, EDhApiGpuUploadMethod gpuUploadMethod) {
        CompletableFuture<ColumnRenderBuffer> future = this.uploadFuture;
        if (future != null) {
            return future;
        }
        this.uploadFuture = future = new CompletableFuture();
        ArrayList<ByteBuffer> opaqueBuffers = builder.makeOpaqueVertexBuffers();
        ArrayList<ByteBuffer> transparentBuffers = builder.makeTransparentVertexBuffers();
        this.vbos = ColumnRenderBuffer.resizeBuffer(this.vbos, opaqueBuffers.size());
        this.vbosTransparent = ColumnRenderBuffer.resizeBuffer(this.vbosTransparent, transparentBuffers.size());
        GLProxy.getInstance().queueRunningOnRenderThread(() -> {
            try {
                if (Thread.interrupted() || this.uploadFuture.isCancelled()) {
                    throw new InterruptedException();
                }
                ColumnRenderBuffer.uploadBuffersDirect(this.vbos, opaqueBuffers, gpuUploadMethod);
                ColumnRenderBuffer.uploadBuffersDirect(this.vbosTransparent, transparentBuffers, gpuUploadMethod);
                this.buffersUploaded = true;
                this.uploadFuture.complete(this);
                this.uploadFuture = null;
            }
            catch (InterruptedException ignore) {
                this.uploadFuture.complete(this);
                this.uploadFuture = null;
            }
            catch (Exception e) {
                LOGGER.error("Unexpected issue uploading buffer [" + this.blockPos + "], error: [" + e.getMessage() + "].", (Throwable)e);
                this.uploadFuture.completeExceptionally(e);
                this.uploadFuture = null;
            }
            finally {
                for (ByteBuffer buffer : opaqueBuffers) {
                    MemoryUtil.memFree((Buffer)buffer);
                }
                for (ByteBuffer buffer : transparentBuffers) {
                    MemoryUtil.memFree((Buffer)buffer);
                }
            }
        });
        return future;
    }

    private static GLVertexBuffer[] resizeBuffer(GLVertexBuffer[] vbos, int newSize) {
        if (vbos.length == newSize) {
            return vbos;
        }
        GLVertexBuffer[] newVbos = new GLVertexBuffer[newSize];
        System.arraycopy(vbos, 0, newVbos, 0, Math.min(vbos.length, newSize));
        if (newSize < vbos.length) {
            for (int i = newSize; i < vbos.length; ++i) {
                if (vbos[i] == null) continue;
                vbos[i].close();
            }
        }
        return newVbos;
    }

    private static void uploadBuffersDirect(GLVertexBuffer[] vbos, ArrayList<ByteBuffer> byteBuffers, EDhApiGpuUploadMethod method) throws InterruptedException {
        int vboIndex = 0;
        for (int i = 0; i < byteBuffers.size(); ++i) {
            if (vboIndex >= vbos.length) {
                throw new RuntimeException("Too many vertex buffers!!");
            }
            if (vbos[vboIndex] == null) {
                vbos[vboIndex] = new GLVertexBuffer(method.useBufferStorage);
            }
            GLVertexBuffer vbo = vbos[vboIndex];
            ByteBuffer buffer = byteBuffers.get(i);
            int size = buffer.limit() - buffer.position();
            try {
                vbo.bind();
                vbo.uploadBuffer(buffer, size / LodUtil.LOD_VERTEX_FORMAT.getByteSize(), method, FULL_SIZED_BUFFER);
            }
            catch (Exception e) {
                vbos[vboIndex] = null;
                vbo.close();
                LOGGER.error("Failed to upload buffer: ", (Throwable)e);
            }
            ++vboIndex;
        }
        if (vboIndex < vbos.length) {
            throw new RuntimeException("Too few vertex buffers!!");
        }
    }

    public boolean renderOpaque(LodRenderer renderContext, DhApiRenderParam renderEventParam) {
        boolean hasRendered = false;
        renderContext.setModelViewMatrixOffset(this.blockPos, renderEventParam);
        for (GLVertexBuffer vbo : this.vbos) {
            if (vbo == null || vbo.getVertexCount() == 0) continue;
            hasRendered = true;
            renderContext.drawVbo(vbo, this);
        }
        return hasRendered;
    }

    public boolean renderTransparent(LodRenderer renderContext, DhApiRenderParam renderEventParam) {
        boolean hasRendered = false;
        try {
            renderContext.setModelViewMatrixOffset(this.blockPos, renderEventParam);
            for (GLVertexBuffer vbo : this.vbosTransparent) {
                if (vbo == null || vbo.getVertexCount() == 0) continue;
                hasRendered = true;
                renderContext.drawVbo(vbo, this);
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("renderContext program doesn't exist for pos: " + this.blockPos, (Throwable)e);
        }
        return hasRendered;
    }

    public boolean hasNonNullVbos() {
        return this.vbos != null || this.vbosTransparent != null;
    }

    public int vboBufferCount() {
        int count = 0;
        if (this.vbos != null) {
            count += this.vbos.length;
        }
        if (this.vbosTransparent != null) {
            count += this.vbosTransparent.length;
        }
        return count;
    }

    public boolean uploadInProgress() {
        return this.uploadFuture != null;
    }

    public void debugDumpStats(StatsMap statsMap) {
        statsMap.incStat("RenderBuffers");
        statsMap.incStat("SimpleRenderBuffers");
        for (GLVertexBuffer vertexBuffer : this.vbos) {
            if (vertexBuffer == null) continue;
            statsMap.incStat("VBOs");
            if (vertexBuffer.getSize() == FULL_SIZED_BUFFER) {
                statsMap.incStat("FullsizedVBOs");
            }
            if (vertexBuffer.getSize() == 0) {
                GLProxy.GL_LOGGER.warn("VBO with size 0", new Object[0]);
            }
            statsMap.incBytesStat("TotalUsage", vertexBuffer.getSize());
        }
    }

    @Override
    public void close() {
        this.buffersUploaded = false;
        GLProxy.getInstance().queueRunningOnRenderThread(() -> {
            for (GLVertexBuffer buffer : this.vbos) {
                if (buffer == null) continue;
                buffer.destroyAsync();
            }
            for (GLVertexBuffer buffer : this.vbosTransparent) {
                if (buffer == null) continue;
                buffer.destroyAsync();
            }
        });
    }
}

