/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fabric.cn.zbx1425.worldcomment.ServerConfig;
import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.client.ClientRayPicking;
import fabric.cn.zbx1425.worldcomment.data.client.ClientWorldData;
import fabric.cn.zbx1425.worldcomment.data.network.ImageDownload;
import fabric.cn.zbx1425.worldcomment.data.network.upload.ImageUploader;
import fabric.cn.zbx1425.worldcomment.interop.AccessoriesInterop;
import fabric.cn.zbx1425.worldcomment.item.CommentToolItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1934;
import net.minecraft.class_2540;
import net.minecraft.class_310;

public class ClientConfig {
    public boolean screenshotIncludeGui = false;
    public boolean screenshotIncludeComments = false;
    public List<ImageUploader> imageUploader;
    public int allowMarkerUsage;
    public int commentVisibilityCriteria;
    public int markerVisibilityCriteria;
    public boolean imageGlobalKill = false;
    public boolean commentVisibilityMask = true;
    float accumulatedDeltaTicks = 0.0f;

    public static ClientConfig fromServerConfig(ServerConfig serverConfig) {
        ClientConfig config = new ClientConfig();
        config.imageUploader = ImageUploader.parseUploaderList(serverConfig.parseUploaderConfig());
        config.allowMarkerUsage = switch (serverConfig.allowMarkerUsage.value) {
            case "op" -> 0;
            case "creative" -> 1;
            case "all" -> 2;
            default -> 1;
        };
        config.commentVisibilityCriteria = switch (serverConfig.commentVisibilityCriteria.value) {
            case "tool_toggle" -> 0;
            case "glass_worn" -> 1;
            case "always" -> 999;
            case "never" -> -1;
            default -> 0;
        };
        config.markerVisibilityCriteria = switch (serverConfig.markerVisibilityCriteria.value) {
            case "tool_toggle" -> 0;
            case "glass_worn" -> 1;
            case "always" -> 999;
            case "never" -> -1;
            default -> 0;
        };
        config.imageGlobalKill = serverConfig.imageGlobalKill.value.equals("true");
        return config;
    }

    public void readPacket(class_2540 packet) {
        int uploaderCount = packet.readInt();
        ArrayList<JsonObject> uploaderConfigs = new ArrayList<JsonObject>();
        for (int i = 0; i < uploaderCount; ++i) {
            uploaderConfigs.add(JsonParser.parseString((String)packet.method_19772()).getAsJsonObject());
        }
        this.imageUploader = ImageUploader.parseUploaderList(uploaderConfigs);
        this.allowMarkerUsage = packet.readInt();
        this.commentVisibilityCriteria = packet.readInt();
        this.imageGlobalKill = packet.readBoolean();
    }

    public void writePacket(class_2540 packet) {
        packet.writeInt(this.imageUploader.size());
        for (ImageUploader uploader : this.imageUploader) {
            packet.method_10814(uploader.serialize().toString());
        }
        packet.writeInt(this.allowMarkerUsage);
        packet.writeInt(this.commentVisibilityCriteria);
        packet.writeBoolean(this.imageGlobalKill);
    }

    public boolean canAccessBuildMarkers(class_310 minecraft) {
        return switch (this.allowMarkerUsage) {
            case 0 -> minecraft.field_1724.method_5687(2);
            case 1 -> {
                if (minecraft.field_1761.method_2920() == class_1934.field_9220) {
                    yield true;
                }
                yield false;
            }
            case 2 -> true;
            default -> false;
        };
    }

    public boolean isCommentVisible(class_310 minecraft, CommentEntry comment) {
        if (!this.commentVisibilityMask) {
            return false;
        }
        int criteriaToUse = comment.messageType - 1 >= 4 ? this.markerVisibilityCriteria : this.commentVisibilityCriteria;
        return switch (criteriaToUse) {
            case 0 -> CommentToolItem.getVisibilityPreference();
            case 1 -> AccessoriesInterop.isWearingEyeglass();
            case 999 -> true;
            default -> false;
        };
    }

    public void tick(float deltaTicks, float partialTick) {
        this.accumulatedDeltaTicks += deltaTicks;
        if (this.accumulatedDeltaTicks < 2.0f) {
            return;
        }
        ImageDownload.purgeUnused();
        ClientWorldData.INSTANCE.tick();
        CommentToolItem.updateInvisibilityTimer(this.accumulatedDeltaTicks);
        ClientRayPicking.tick(partialTick, 20.0f);
        this.accumulatedDeltaTicks = 0.0f;
    }
}

