/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fabric.cn.zbx1425.worldcomment.data.ServerWorldData;
import fabric.cn.zbx1425.worldcomment.data.network.ThumbImage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class CommentEntry {
    public static int REGION_SHIFT = 2;
    public static final int MESSAGE_MAX_LENGTH = 256;
    public long id;
    public long timestamp;
    public class_2960 level;
    public class_1923 region;
    public class_2338 location;
    public UUID initiator;
    public String initiatorName;
    public int messageType;
    public String message;
    public ThumbImage image;
    public boolean deleted;
    public boolean uplinkSent;
    public int like;
    public long fileOffset;

    public CommentEntry(class_1657 initiator, boolean isAnonymous, int messageType, String message) {
        this.id = ServerWorldData.SNOWFLAKE.nextId();
        this.timestamp = System.currentTimeMillis();
        this.level = initiator.method_37908().method_27983().method_29177();
        this.initiator = initiator.method_7334().getId();
        this.initiatorName = isAnonymous ? "" : initiator.method_7334().getName();
        this.messageType = messageType;
        this.message = message;
        this.deleted = false;
    }

    public CommentEntry(class_2960 level, class_2540 src, boolean fromFile) {
        this.fileOffset = src.readerIndex();
        this.deleted = src.readBoolean();
        this.uplinkSent = src.readBoolean();
        src.skipBytes(2);
        this.like = src.readInt();
        src.skipBytes(8);
        this.id = src.readLong();
        this.timestamp = src.readLong();
        this.level = level;
        this.location = src.method_10811();
        this.region = new class_1923(this.location.method_10263() >> 4 + REGION_SHIFT, this.location.method_10260() >> 4 + REGION_SHIFT);
        this.initiator = src.method_10790();
        this.initiatorName = src.method_19772();
        this.messageType = src.readInt();
        this.message = src.method_19772();
        this.image = new ThumbImage(src.method_19772(), src.method_19772());
        if (fromFile) {
            src.skipBytes(16 - src.readerIndex() % 16);
        }
    }

    public void setLocation(class_2338 location) {
        this.location = location;
        this.region = new class_1923(location.method_10263() >> 4 + REGION_SHIFT, location.method_10260() >> 4 + REGION_SHIFT);
    }

    public void copyFrom(CommentEntry other) {
        this.messageType = other.messageType;
        this.message = other.message;
        this.image = other.image;
        this.deleted = other.deleted;
        this.uplinkSent = other.uplinkSent;
        this.like = other.like;
    }

    public void writeBuffer(class_2540 dst, boolean toFile) {
        dst.writeBoolean(this.deleted);
        dst.writeBoolean(this.uplinkSent);
        dst.writeZero(2);
        dst.writeInt(this.like);
        dst.writeBytes("====ZBX=".getBytes(StandardCharsets.UTF_8));
        dst.writeLong(this.id);
        dst.writeLong(this.timestamp);
        dst.method_10807(this.location);
        dst.method_10797(this.initiator);
        dst.method_10814(this.initiatorName);
        dst.writeInt(this.messageType);
        dst.method_10814(this.message);
        dst.method_10814(this.image.url);
        dst.method_10814(this.image.thumbUrl);
        if (toFile) {
            dst.writeZero(16 - dst.writerIndex() % 16);
        }
    }

    public void writeFileStream(FileOutputStream oStream) throws IOException {
        class_2540 buf = new class_2540(Unpooled.buffer((int)512));
        this.writeBuffer(buf, true);
        this.fileOffset = oStream.getChannel().position();
        oStream.write(buf.array(), 0, buf.writerIndex());
    }

    public void updateInFile(RandomAccessFile oFile) throws IOException {
        oFile.seek(this.fileOffset);
        oFile.writeBoolean(this.deleted);
        oFile.writeBoolean(this.uplinkSent);
        oFile.write(new byte[2]);
        oFile.writeInt(this.like);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", (Number)this.id);
        json.addProperty("timestamp", (Number)this.timestamp);
        json.addProperty("level", this.level.toString());
        JsonArray blockPosArr = new JsonArray();
        blockPosArr.add((Number)this.location.method_10263());
        blockPosArr.add((Number)this.location.method_10264());
        blockPosArr.add((Number)this.location.method_10260());
        json.add("location", (JsonElement)blockPosArr);
        json.addProperty("initiator", this.initiator.toString());
        json.addProperty("initiatorName", this.initiatorName);
        json.addProperty("messageType", (Number)this.messageType);
        json.addProperty("message", this.message);
        json.add("image", (JsonElement)this.image.toJson());
        json.addProperty("deleted", Boolean.valueOf(this.deleted));
        json.addProperty("like", (Number)this.like);
        return json;
    }

    public ByteBuf toBinaryBuffer() {
        class_2540 dest = new class_2540(Unpooled.buffer((int)512));
        dest.method_10812(this.level);
        this.writeBuffer(dest, false);
        return dest;
    }

    public static CommentEntry fromBinaryBuffer(ByteBuf buf) {
        class_2540 src = new class_2540(buf);
        class_2960 level = src.method_10810();
        return new CommentEntry(level, src, false);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

