/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.data.network;

import fabric.cn.zbx1425.worldcomment.Main;
import fabric.cn.zbx1425.worldcomment.MainClient;
import fabric.cn.zbx1425.worldcomment.data.network.ImageConvertClient;
import fabric.cn.zbx1425.worldcomment.data.network.ThumbImage;
import fabric.cn.zbx1425.worldcomment.data.network.upload.ImageUploader;
import fabric.cn.zbx1425.worldcomment.data.network.upload.LocalStorageUploader;
import fabric.cn.zbx1425.worldcomment.util.OffHeapAllocator;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_310;
import org.apache.commons.codec.digest.DigestUtils;

public class ImageDownload {
    private static final Map<String, ImageState> images = new HashMap<String, ImageState>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageState getTexture(ThumbImage image, boolean thumb) {
        if (image.url.isEmpty() || MainClient.CLIENT_CONFIG.imageGlobalKill) {
            return ImageState.BLANK;
        }
        String targetUrl = thumb && !image.thumbUrl.isEmpty() ? image.thumbUrl : image.url;
        Map<String, ImageState> map = images;
        synchronized (map) {
            if (images.containsKey(targetUrl)) {
                return ImageDownload.queryTexture(targetUrl);
            }
            images.put(targetUrl, new ImageState());
        }
        Main.IO_EXECUTOR.execute(() -> {
            try {
                byte[] localImageData = ImageDownload.getLocalImageData(image.url);
                if (localImageData != null) {
                    ImageDownload.applyImageData(targetUrl, localImageData);
                    return;
                }
            }
            catch (IOException ex) {
                Main.LOGGER.warn("Cannot read local image {}", (Object)image.url, (Object)ex);
            }
            ImageDownload.downloadImage(targetUrl);
        });
        return ImageDownload.queryTexture(targetUrl);
    }

    private static void downloadImage(String url) {
        if (url.startsWith("file://worldcomment/")) {
            ((CompletableFuture)LocalStorageUploader.downloadImage(url).thenAccept(imageData -> ImageDownload.applyImageData(url, imageData))).exceptionally(ex -> {
                Main.LOGGER.warn("Cannot download image {}", (Object)url, ex);
                Map<String, ImageState> map = images;
                synchronized (map) {
                    if (!images.containsKey(url)) {
                        return null;
                    }
                    ImageDownload.images.get((Object)url).failed = true;
                }
                return null;
            });
        } else {
            HttpRequest request = ImageUploader.requestBuilder(URI.create(url)).timeout(Duration.of(10L, ChronoUnit.SECONDS)).GET().build();
            ((CompletableFuture)Main.HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofByteArray()).thenAccept(response -> {
                if (response.statusCode() != 200) {
                    throw new CompletionException(new IOException("HTTP Error Code " + response.statusCode()));
                }
                byte[] imageData = (byte[])response.body();
                ImageDownload.applyImageData(url, imageData);
            })).exceptionally(ex -> {
                Main.LOGGER.warn("Cannot download image {}", (Object)url, ex);
                Map<String, ImageState> map = images;
                synchronized (map) {
                    if (!images.containsKey(url)) {
                        return null;
                    }
                    ImageDownload.images.get((Object)url).failed = true;
                }
                return null;
            });
        }
    }

    private static byte[] getLocalImageData(String url) throws IOException {
        Path imageBaseDir = class_310.method_1551().field_1697.toPath().resolve("worldcomment-images");
        Path imagePath = imageBaseDir.resolve(ImageDownload.getCacheFileName(url));
        if (Files.exists(imagePath, new LinkOption[0])) {
            return Files.readAllBytes(imagePath);
        }
        return null;
    }

    private static void applyImageData(String url, byte[] pngOrJpgImageData) {
        byte[] imageData = pngOrJpgImageData;
        if (url.toLowerCase(Locale.ROOT).endsWith(".jpg")) {
            imageData = ImageConvertClient.toPng(imageData);
        }
        ByteBuffer buffer = OffHeapAllocator.allocate(imageData.length);
        buffer.put(imageData);
        buffer.rewind();
        class_310.method_1551().execute(() -> {
            try {
                class_1011 pixels = class_1011.method_4324((ByteBuffer)buffer);
                class_1043 dynamicTexture = new class_1043(pixels);
                Map<String, ImageState> map = images;
                synchronized (map) {
                    block15: {
                        ImageState sink = images.get(url);
                        if (sink != null) break block15;
                        return;
                    }
                    sink.texture = dynamicTexture;
                    sink.width = pixels.method_4307();
                    sink.height = pixels.method_4323();
                }
            }
            catch (Throwable ex) {
                Main.LOGGER.warn("Cannot store image " + url, ex);
                Map<String, ImageState> map = images;
                synchronized (map) {
                    block17: {
                        if (images.containsKey(url)) break block17;
                        return;
                    }
                    ImageDownload.images.get((Object)url).failed = true;
                }
            }
            finally {
                OffHeapAllocator.free(buffer);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageState queryTexture(String url) {
        Map<String, ImageState> map = images;
        synchronized (map) {
            ImageState state = images.get(url);
            state.onQuery();
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeUnused() {
        long currentTime = System.currentTimeMillis();
        Map<String, ImageState> map = images;
        synchronized (map) {
            Iterator<Map.Entry<String, ImageState>> iterator = images.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ImageState> entry = iterator.next();
                if (currentTime - entry.getValue().lastQueryTime <= 60000L) continue;
                if (entry.getValue().texture != null) {
                    entry.getValue().texture.close();
                }
                iterator.remove();
            }
        }
    }

    public static String getCacheFileName(String url) {
        byte[] urlBytes = url.getBytes(StandardCharsets.UTF_8);
        String hash = DigestUtils.sha1Hex((byte[])urlBytes);
        String extension = url.toLowerCase().endsWith(".jpg") ? ".jpg" : ".png";
        return String.format("url-sha1-%s%s", hash, extension);
    }

    public static class ImageState {
        public class_1043 texture;
        public int width = 16;
        public int height = 9;
        public boolean failed;
        public boolean blank;
        public long lastQueryTime;
        public static final ImageState BLANK = new ImageState(true);

        private ImageState(boolean blank) {
            this.blank = blank;
        }

        public ImageState() {
            this(false);
        }

        public void onQuery() {
            this.lastQueryTime = System.currentTimeMillis();
        }

        public class_1044 getFriendlyTexture(class_1060 textureManager) {
            if (this.failed) {
                return textureManager.method_4619(Main.id("textures/gui/placeholder-failed.png"));
            }
            if (this.texture != null) {
                return this.texture;
            }
            if (this.blank) {
                return textureManager.method_4619(Main.id("textures/gui/placeholder-blank.png"));
            }
            return textureManager.method_4619(Main.id("textures/gui/placeholder-loading.png"));
        }
    }
}

