/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.data.network;

import fabric.cn.zbx1425.worldcomment.Main;
import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.ServerWorldData;
import fabric.cn.zbx1425.worldcomment.data.network.ImageDownload;
import fabric.cn.zbx1425.worldcomment.data.network.upload.ImageUploader;
import fabric.cn.zbx1425.worldcomment.network.PacketCollectionRequestC2S;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class ImageDump {
    private static long lastRequestNonce = 0L;
    private static String lastRequestDirName = "";

    public static void requestDumpComments(String dirName) {
        lastRequestNonce = ServerWorldData.SNOWFLAKE.nextId();
        lastRequestDirName = dirName;
        PacketCollectionRequestC2S.ClientLogics.sendLatest(0, Integer.MAX_VALUE, lastRequestNonce);
    }

    public static void handleDumpResponse(List<CommentEntry> comments, long nonce) {
        if (nonce != lastRequestNonce) {
            return;
        }
        Path storeDir = class_310.method_1551().field_1697.toPath().resolve("worldcomment-images").resolve(lastRequestDirName);
        try {
            if (!Files.isDirectory(storeDir, new LinkOption[0])) {
                Files.createDirectories(storeDir, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            Main.LOGGER.error("Cannot create image dump directory", (Throwable)ex);
            return;
        }
        Main.IO_EXECUTOR.execute(() -> {
            for (int i = 0; i < comments.size(); ++i) {
                Path filePath;
                int finalI = i;
                class_310.method_1551().execute(() -> {
                    if (class_310.method_1551().field_1724 != null) {
                        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("WorldComment: Downloading " + (finalI + 1) + "/" + comments.size())), true);
                    }
                });
                CommentEntry comment = (CommentEntry)comments.get(i);
                String targetUrl = comment.image.url;
                if (targetUrl.isEmpty() || Files.exists(filePath = storeDir.resolve(ImageDownload.getCacheFileName(targetUrl)), new LinkOption[0])) continue;
                try {
                    URI url = URI.create(targetUrl);
                    if (url.getScheme().equals("file")) continue;
                    byte[] imageData = Main.HTTP_CLIENT.send(ImageUploader.requestBuilder(url).timeout(Duration.of(10L, ChronoUnit.SECONDS)).GET().build(), HttpResponse.BodyHandlers.ofByteArray()).body();
                    Files.write(filePath, imageData, new OpenOption[0]);
                    continue;
                }
                catch (IOException | InterruptedException ex) {
                    Main.LOGGER.warn("Cannot download image {}", (Object)targetUrl, (Object)ex);
                }
            }
            class_310.method_1551().execute(() -> {
                if (class_310.method_1551().field_1724 != null) {
                    class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"WorldComment: Download finished"), false);
                }
            });
        });
    }
}

