/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.data.network.uplink;

import com.google.common.hash.Hashing;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fabric.cn.zbx1425.worldcomment.Main;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class UplinkRequest {
    public final String url;
    public final String method;
    public final JsonObject payload;
    public final Consumer<JsonObject> callback;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();

    public UplinkRequest(String url, JsonObject payload) {
        this(url, "POST", payload, null);
    }

    public UplinkRequest(String url, String method, JsonObject payload, Consumer<JsonObject> callback) {
        this.url = url;
        this.method = method;
        this.payload = payload;
        this.callback = callback;
    }

    public void sendBlocking() {
        try {
            int c;
            HttpURLConnection conn = (HttpURLConnection)new URL(this.url).openConnection();
            conn.setRequestMethod(this.method);
            if (this.payload != null) {
                JsonObject objectToSend = this.payload.deepCopy();
                objectToSend.addProperty("requestTimestamp", (Number)Instant.now().getEpochSecond());
                byte[] postDataBytes = objectToSend.toString().getBytes(StandardCharsets.UTF_8);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
                if (!Main.SERVER_CONFIG.uplinkAuthKey.value.isEmpty()) {
                    byte[] signatureBytes = Hashing.hmacSha1((byte[])Main.SERVER_CONFIG.uplinkAuthKey.value.getBytes(StandardCharsets.UTF_8)).hashBytes(postDataBytes).asBytes();
                    conn.setRequestProperty("Authorization", "NEX-HMAC-SHA1 Signature=" + Base64.getEncoder().encodeToString(signatureBytes));
                }
                conn.setDoOutput(true);
                conn.getOutputStream().write(postDataBytes);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((c = ((Reader)in).read()) >= 0) {
                sb.append((char)c);
            }
            Main.LOGGER.info(sb.toString());
            if (this.callback != null) {
                this.callback.accept(JsonParser.parseString((String)sb.toString()).getAsJsonObject());
            }
        }
        catch (Exception ex) {
            Main.LOGGER.warn("Failed sending uplink request: ", (Throwable)ex);
        }
    }

    public void sendAsync() {
        executor.submit(this::sendBlocking);
    }
}

