/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.data.network.upload;

import com.google.gson.JsonObject;
import fabric.cn.zbx1425.worldcomment.Main;
import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.network.ThumbImage;
import fabric.cn.zbx1425.worldcomment.data.network.upload.ImglocUploader;
import fabric.cn.zbx1425.worldcomment.data.network.upload.LocalStorageUploader;
import fabric.cn.zbx1425.worldcomment.data.network.upload.LskyUploader;
import fabric.cn.zbx1425.worldcomment.data.network.upload.SmmsUploader;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_310;

public abstract class ImageUploader {
    public static int IMAGE_MAX_WIDTH = 1920;
    public static int THUMBNAIL_MAX_WIDTH = 256;
    public static int THUMBNAIL_QUALITY = 85;

    public abstract CompletableFuture<ThumbImage> uploadImage(byte[] var1, CommentEntry var2);

    public abstract JsonObject serialize();

    public static List<ImageUploader> parseUploaderList(List<JsonObject> configs) {
        ArrayList<ImageUploader> uploaders = new ArrayList<ImageUploader>();
        if (configs == null || configs.isEmpty()) {
            uploaders.add(LocalStorageUploader.getInstance());
        } else {
            for (JsonObject config : configs) {
                uploaders.add(ImageUploader.getUploader(config));
            }
        }
        uploaders.add(NoopUploader.INSTANCE);
        return uploaders;
    }

    public static ImageUploader getUploader(JsonObject config) {
        String service = config.has("service") ? config.get("service").getAsString() : "";
        return switch (service.toLowerCase()) {
            case "" -> NoopUploader.INSTANCE;
            case "local" -> LocalStorageUploader.deserialize(config);
            case "imgloc" -> new ImglocUploader(config);
            case "smms" -> new SmmsUploader(config);
            case "lsky" -> new LskyUploader(config);
            default -> throw new IllegalStateException("Unknown service: " + service);
        };
    }

    public static HttpRequest.Builder requestBuilder(URI uri) {
        return HttpRequest.newBuilder(uri).header("User-Agent", "Mozilla/5.0 WorldComment/1.20.1-0.3.2 +https://www.zbx1425.cn").header("X-Minecraft-Username", class_310.method_1551().method_1548().method_1676()).header("X-Minecraft-UUID", class_310.method_1551().method_1548().method_44717().toString());
    }

    public static class NoopUploader
    extends ImageUploader {
        public static NoopUploader INSTANCE = new NoopUploader();

        @Override
        public CompletableFuture<ThumbImage> uploadImage(byte[] imageBytes, CommentEntry comment) {
            Main.LOGGER.warn("No-op image uploader used for comment from {}. Either no uploader is configured or all uploads failed.", (Object)comment.initiator);
            return CompletableFuture.completedFuture(ThumbImage.NONE);
        }

        @Override
        public JsonObject serialize() {
            return new JsonObject();
        }
    }
}

