/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.data.network.upload;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fabric.cn.zbx1425.worldcomment.Main;
import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.network.ImageConvertClient;
import fabric.cn.zbx1425.worldcomment.data.network.MimeMultipartData;
import fabric.cn.zbx1425.worldcomment.data.network.ThumbImage;
import fabric.cn.zbx1425.worldcomment.data.network.upload.ImageUploader;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class LskyUploader
extends ImageUploader {
    private final String apiUrl;
    private final String apiToken;
    private final Integer strategyId;
    private final Integer albumId;
    private final String cdnImageTransform;
    private final Boolean localThumbGeneration;

    public LskyUploader(JsonObject config) {
        this.apiUrl = config.get("apiUrl").getAsString();
        this.apiToken = config.get("apiToken").getAsString();
        this.strategyId = config.has("strategyId") ? Integer.valueOf(config.get("strategyId").getAsInt()) : null;
        this.albumId = config.has("albumId") ? Integer.valueOf(config.get("albumId").getAsInt()) : null;
        this.cdnImageTransform = config.has("cdnImageTransform") ? config.get("cdnImageTransform").getAsString() : null;
        this.localThumbGeneration = config.has("localThumbGeneration") ? Boolean.valueOf(config.get("localThumbGeneration").getAsBoolean()) : null;
    }

    @Override
    public CompletableFuture<ThumbImage> uploadImage(byte[] imageBytes, CommentEntry comment) {
        String initiatorName;
        String string = initiatorName = comment.initiatorName.isBlank() ? "anonymous" : comment.initiatorName;
        if (this.localThumbGeneration.booleanValue()) {
            CompletableFuture<ThumbImage> fullSizeUrlFuture = this.uploadImage(imageBytes, IMAGE_MAX_WIDTH, "sender-" + initiatorName + ".jpg");
            CompletableFuture<ThumbImage> thumbnailFuture = this.uploadImage(imageBytes, THUMBNAIL_MAX_WIDTH, "sender-" + initiatorName + ".thumb.jpg");
            return CompletableFuture.allOf(fullSizeUrlFuture, thumbnailFuture).thenApply(ignored -> new ThumbImage(((ThumbImage)fullSizeUrlFuture.join()).url, ((ThumbImage)thumbnailFuture.join()).url));
        }
        return this.uploadImage(imageBytes, IMAGE_MAX_WIDTH, "sender-" + initiatorName + ".jpg").thenApply(originalThumb -> {
            String thumbUrl;
            if (this.cdnImageTransform != null) {
                try {
                    URI uri = URI.create(originalThumb.url);
                    String path = uri.getPath();
                    thumbUrl = originalThumb.url.replace(path, this.cdnImageTransform.replace("{thumbWidth}", Integer.toString(ImageUploader.THUMBNAIL_MAX_WIDTH)).replace("{quality100}", Integer.toString(ImageUploader.THUMBNAIL_QUALITY)).replace("{quality1}", String.format("%.2f", Float.valueOf((float)ImageUploader.THUMBNAIL_QUALITY / 100.0f))).replace("{path}", path.substring(1)));
                }
                catch (Exception e) {
                    Main.LOGGER.error("Error transforming thumbnail URL", (Throwable)e);
                    thumbUrl = originalThumb.thumbUrl;
                }
            } else {
                thumbUrl = originalThumb.thumbUrl;
            }
            return new ThumbImage(originalThumb.url, thumbUrl);
        });
    }

    private CompletableFuture<ThumbImage> uploadImage(byte[] imageBytes, int maxWidth, String fileName) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                MimeMultipartData.Builder bodyBuilder = MimeMultipartData.newBuilder().withCharset(StandardCharsets.UTF_8).addFile("file", fileName, ImageConvertClient.toJpegScaled(imageBytes, maxWidth), "application/octet-stream");
                if (this.strategyId != null) {
                    bodyBuilder.addText("strategy_id", Integer.toString(this.strategyId));
                }
                if (this.albumId != null) {
                    bodyBuilder.addText("album_id", Integer.toString(this.albumId));
                }
                MimeMultipartData body = bodyBuilder.build();
                return ImageUploader.requestBuilder(URI.create(this.apiUrl)).header("Content-Type", body.getContentType()).header("Authorization", "Bearer " + this.apiToken).POST(body.getBodyPublisher()).build();
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        }, Main.IO_EXECUTOR).thenCompose(request -> Main.HTTP_CLIENT.sendAsync((HttpRequest)request, HttpResponse.BodyHandlers.ofString()))).thenApply(response -> {
            if (response.statusCode() != 200) {
                throw new CompletionException(new IOException("HTTP Error Code " + response.statusCode() + "\n" + (String)response.body()));
            }
            JsonObject linkObj = JsonParser.parseString((String)((String)response.body())).getAsJsonObject().get("data").getAsJsonObject().get("links").getAsJsonObject();
            return new ThumbImage(linkObj.get("url").getAsString(), linkObj.get("thumbnail_url").getAsString());
        });
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("service", "lsky");
        json.addProperty("apiUrl", this.apiUrl);
        json.addProperty("apiToken", this.apiToken);
        if (this.strategyId != null) {
            json.addProperty("strategyId", (Number)this.strategyId);
        }
        if (this.albumId != null) {
            json.addProperty("albumId", (Number)this.albumId);
        }
        if (this.cdnImageTransform != null) {
            json.addProperty("cdnImageTransform", this.cdnImageTransform);
        }
        if (this.localThumbGeneration != null) {
            json.addProperty("localThumbGeneration", this.localThumbGeneration);
        }
        return json;
    }
}

