/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.data.persist;

import fabric.cn.zbx1425.worldcomment.data.CommentCache;
import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2960;

public class FileSerializer {
    private final Path basePath;

    public FileSerializer(Path basePath) {
        this.basePath = basePath;
    }

    public void loadInto(CommentCache commentCache) throws IOException {
        commentCache.clear();
        try {
            Files.createDirectories(this.basePath.resolve("region"), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        try (Stream<Path> levelFiles = Files.list(this.basePath.resolve("region"));){
            for (Path levelPath : levelFiles.toList()) {
                class_2960 dimension = new class_2960(levelPath.getFileName().toString().replace("+", ":"));
                Stream<Path> files = Files.list(levelPath);
                try {
                    for (Path file : files.toList()) {
                        String[] fileNameParts = file.getFileName().toString().split("\\.");
                        if (fileNameParts.length != 4 || !fileNameParts[3].equals("bin")) continue;
                        class_1923 region = new class_1923(Integer.parseInt(fileNameParts[1]), Integer.parseInt(fileNameParts[2]));
                        byte[] fileContent = Files.readAllBytes(file);
                        commentCache.loadRegion(dimension, region.method_8324(), fileContent, true);
                    }
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
        }
    }

    private Path getLevelPath(class_2960 dimension) {
        return this.basePath.resolve("region").resolve(dimension.method_12836() + "+" + dimension.method_12832());
    }

    private Path getLevelRegionPath(class_2960 dimension, class_1923 region) {
        return this.basePath.resolve("region").resolve(dimension.method_12836() + "+" + dimension.method_12832()).resolve("r." + region.field_9181 + "." + region.field_9180 + ".bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(CommentEntry newEntry) throws IOException {
        FileSerializer fileSerializer = this;
        synchronized (fileSerializer) {
            try {
                Files.createDirectory(this.getLevelPath(newEntry.level), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            Path targetFile = this.getLevelRegionPath(newEntry.level, newEntry.region);
            try (FileOutputStream oStream = new FileOutputStream(targetFile.toFile(), true);){
                newEntry.writeFileStream(oStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CommentEntry existingEntry) throws IOException {
        FileSerializer fileSerializer = this;
        synchronized (fileSerializer) {
            assert (existingEntry.fileOffset > 0L);
            Path targetFile = this.getLevelRegionPath(existingEntry.level, existingEntry.region);
            try (RandomAccessFile oStream = new RandomAccessFile(targetFile.toFile(), "rw");){
                existingEntry.updateInFile(oStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegion(List<CommentEntry> regionEntries) throws IOException {
        FileSerializer fileSerializer = this;
        synchronized (fileSerializer) {
            if (regionEntries.isEmpty()) {
                return;
            }
            CommentEntry pivot = regionEntries.get(0);
            try {
                Files.createDirectory(this.getLevelPath(pivot.level), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            Path targetFile = this.getLevelRegionPath(pivot.level, pivot.region);
            try (FileOutputStream oStream = new FileOutputStream(targetFile.toFile(), false);){
                for (CommentEntry entry : regionEntries) {
                    entry.writeFileStream(oStream);
                }
            }
        }
    }
}

