/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.data.sync;

import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.ServerWorldData;
import fabric.cn.zbx1425.worldcomment.data.sync.RedisSynchronizer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.StatefulRedisConnection;

public class RedisMessage {
    public static final String COMMAND_CHANNEL = "WORLD_COMMENT_COMMAND_CHANNEL";
    private static final long INSTANCE_ID = ServerWorldData.SNOWFLAKE.nextId();
    public long initiator;
    public Action action;
    public ByteBuf content;

    public RedisMessage(Action action, ByteBuf content) {
        this.initiator = INSTANCE_ID;
        this.action = action;
        this.content = content;
    }

    public RedisMessage(ByteBuf src) {
        this.action = Action.values()[src.readByte()];
        this.initiator = src.readLong();
        int length = src.readInt();
        this.content = src.readBytes(length);
    }

    public static RedisMessage insert(CommentEntry entry) {
        return new RedisMessage(Action.INSERT, entry.toBinaryBuffer());
    }

    public static RedisMessage update(CommentEntry entry) {
        return new RedisMessage(Action.UPDATE, entry.toBinaryBuffer());
    }

    public static RedisMessage updateAllFields(CommentEntry entry) {
        return new RedisMessage(Action.UPDATE_ALL_FIELDS, entry.toBinaryBuffer());
    }

    public void publishAsync(StatefulRedisConnection<String, ByteBuf> connection) {
        ByteBuf buffer = Unpooled.buffer((int)(this.content.readableBytes() + 16));
        buffer.writeByte(this.action.ordinal());
        buffer.writeLong(this.initiator);
        buffer.writeInt(this.content.readableBytes());
        buffer.writeBytes(this.content);
        connection.async().publish(COMMAND_CHANNEL, buffer);
    }

    public void handle(RedisSynchronizer synchronizer) throws IOException {
        if (this.isFromSelf()) {
            return;
        }
        switch (this.action.ordinal()) {
            case 0: {
                synchronizer.handleInsert(CommentEntry.fromBinaryBuffer(this.content));
                break;
            }
            case 1: {
                synchronizer.handleUpdate(CommentEntry.fromBinaryBuffer(this.content));
                break;
            }
            case 2: {
                synchronizer.handleUpdateAllFields(CommentEntry.fromBinaryBuffer(this.content));
            }
        }
    }

    public boolean isFromSelf() {
        return this.initiator == INSTANCE_ID;
    }

    public static enum Action {
        INSERT,
        UPDATE,
        UPDATE_ALL_FIELDS;

    }
}

