/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.data.sync;

import fabric.cn.zbx1425.worldcomment.Main;
import fabric.cn.zbx1425.worldcomment.data.CommentCache;
import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.ServerWorldData;
import fabric.cn.zbx1425.worldcomment.data.sync.RedisMessage;
import fabric.cn.zbx1425.worldcomment.data.sync.Synchronizer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.RedisClient;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.StatefulRedisConnection;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.api.async.RedisAsyncCommands;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.RedisCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.codec.StringCodec;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.pubsub.RedisPubSubListener;
import vendor.cn.zbx1425.worldcomment.io.lettuce.core.pubsub.StatefulRedisPubSubConnection;

public class RedisSynchronizer
implements Synchronizer {
    private final StatefulRedisPubSubConnection<String, ByteBuf> redisSub;
    private final StatefulRedisConnection<String, ByteBuf> redisConn;
    public static final String HMAP_ALL_KEY = "WORLD_COMMENT_DATA_ALL";
    private final ServerWorldData serverWorldData;

    public RedisSynchronizer(String URI2, ServerWorldData serverWorldData) {
        this.redisConn = RedisClient.create(URI2).connect(ByteBufCodec.INSTANCE);
        this.redisSub = RedisClient.create(URI2).connectPubSub(ByteBufCodec.INSTANCE);
        this.redisSub.addListener(new Listener());
        this.redisSub.sync().subscribe("WORLD_COMMENT_COMMAND_CHANNEL");
        this.serverWorldData = serverWorldData;
    }

    @Override
    public void kvWriteAll(Long2ObjectSortedMap<CommentEntry> all) {
        RedisAsyncCommands<String, ByteBuf> commands = this.redisConn.async();
        commands.multi();
        commands.del((String[])new String[]{HMAP_ALL_KEY});
        HashMap<String, ByteBuf> data = new HashMap<String, ByteBuf>();
        for (CommentEntry entry : all.values()) {
            data.put(Long.toHexString(entry.id), entry.toBinaryBuffer());
        }
        commands.hset(HMAP_ALL_KEY, data);
        commands.exec();
    }

    @Override
    public void kvWriteEntry(CommentEntry newEntry) {
        if (newEntry.deleted) {
            this.redisConn.async().hdel(HMAP_ALL_KEY, (String[])new String[]{Long.toHexString(newEntry.id)});
        } else {
            this.redisConn.async().hset(HMAP_ALL_KEY, Long.toHexString(newEntry.id), newEntry.toBinaryBuffer());
        }
    }

    @Override
    public void notifyInsert(CommentEntry newEntry) {
        RedisMessage.insert(newEntry).publishAsync(this.redisConn);
    }

    protected void handleInsert(CommentEntry peerEntry) throws IOException {
        this.serverWorldData.insert(peerEntry, true);
    }

    @Override
    public void notifyUpdate(CommentEntry newEntry) {
        RedisMessage.update(newEntry).publishAsync(this.redisConn);
    }

    protected void handleUpdate(CommentEntry peerEntry) throws IOException {
        this.serverWorldData.update(peerEntry, true);
    }

    @Override
    public void notifyUpdateAllFields(CommentEntry newEntry) {
        RedisMessage.updateAllFields(newEntry).publishAsync(this.redisConn);
    }

    protected void handleUpdateAllFields(CommentEntry peerEntry) throws IOException {
        this.serverWorldData.updateAllFields(peerEntry, true);
    }

    @Override
    public void kvReadAllInto(CommentCache comments) throws IOException {
        Map data = this.redisConn.sync().hgetall(HMAP_ALL_KEY);
        for (ByteBuf entry : data.values()) {
            comments.insert(CommentEntry.fromBinaryBuffer(entry));
        }
    }

    @Override
    public void close() {
        this.redisSub.close();
        this.redisConn.close();
    }

    private static class ByteBufCodec
    implements RedisCodec<String, ByteBuf> {
        public static ByteBufCodec INSTANCE = new ByteBufCodec();

        private ByteBufCodec() {
        }

        @Override
        public String decodeKey(ByteBuffer bytes) {
            return StringCodec.UTF8.decodeKey(bytes);
        }

        @Override
        public ByteBuf decodeValue(ByteBuffer bytes) {
            ByteBuf result = Unpooled.buffer((int)bytes.remaining());
            result.writeBytes(bytes);
            return result;
        }

        @Override
        public ByteBuffer encodeKey(String key) {
            return StringCodec.UTF8.encodeKey(key);
        }

        @Override
        public ByteBuffer encodeValue(ByteBuf value) {
            return value.nioBuffer();
        }
    }

    public class Listener
    implements RedisPubSubListener<String, ByteBuf> {
        @Override
        public void message(String channel, ByteBuf rawMessage) {
            RedisMessage message = new RedisMessage(rawMessage);
            try {
                message.handle(RedisSynchronizer.this);
            }
            catch (IOException ex) {
                Main.LOGGER.error("Redis handler", (Throwable)ex);
            }
        }

        @Override
        public void message(String pattern, String channel, ByteBuf message) {
        }

        @Override
        public void subscribed(String channel, long count) {
        }

        @Override
        public void psubscribed(String pattern, long count) {
        }

        @Override
        public void unsubscribed(String channel, long count) {
        }

        @Override
        public void punsubscribed(String pattern, long count) {
        }
    }
}

