/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.ServerWorldData;
import fabric.cn.zbx1425.worldcomment.data.client.ClientRayPicking;
import fabric.cn.zbx1425.worldcomment.data.client.ClientWorldData;
import fabric.cn.zbx1425.worldcomment.data.network.ImageDownload;
import fabric.cn.zbx1425.worldcomment.gui.IGuiCommon;
import fabric.cn.zbx1425.worldcomment.gui.WidgetColorButton;
import fabric.cn.zbx1425.worldcomment.gui.WidgetCommentEntry;
import fabric.cn.zbx1425.worldcomment.network.PacketCollectionRequestC2S;
import fabric.cn.zbx1425.worldcomment.network.PacketEntryActionC2S;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class CommentListScreen
extends class_437
implements IGuiCommon {
    int subScreen = 0;
    int prevSubScreen = 0;
    class_4185[] pageButtons = new class_4185[4];
    List<CommentEntry> commentList = new ArrayList<CommentEntry>();
    int commentListOffset = 0;
    int latestCommentsRequestedAmount = 0;
    private final int latestCommentsPageSize = 20;
    CommentEntry commentForDetail;
    CommentEntry commentToDelete;
    private final Map<CommentEntry, WidgetCommentEntry> widgets = new WeakHashMap<CommentEntry, WidgetCommentEntry>();
    private double accumulatedScroll = 0.0;
    private long lastRequestNonce;

    protected CommentListScreen(CommentEntry commentForDetail) {
        super((class_2561)class_2561.method_43470((String)""));
        this.commentForDetail = commentForDetail;
        this.useSubScreen(commentForDetail != null ? 3 : 0);
        this.prevSubScreen = commentForDetail != null ? 3 : 0;
    }

    private WidgetCommentEntry getWidget(CommentEntry entry) {
        return this.widgets.computeIfAbsent(entry, WidgetCommentEntry::new);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        int commentEntryWidth = Math.min(this.field_22789 - 100 - 20 - 10, 250);
        int bookWidth = this.subScreen == 3 ? this.field_22789 : commentEntryWidth + 100 + 20 + 10;
        int xOffset = (this.field_22789 - bookWidth) / 2;
        int xOffsetR = this.field_22789 - xOffset;
        this.pageButtons[0] = (class_4185)this.method_37063((class_364)new WidgetColorButton(xOffset + 10, 40, 80, 20, (class_2561)class_2561.method_43471((String)"gui.worldcomment.list.nearby_posts"), -1739917, sender -> this.useSubScreen(0)));
        this.pageButtons[1] = (class_4185)this.method_37063((class_364)new WidgetColorButton(xOffset + 10, 64, 80, 20, (class_2561)class_2561.method_43471((String)"gui.worldcomment.list.recent_posts"), -1739917, sender -> this.useSubScreen(1)));
        this.pageButtons[2] = (class_4185)this.method_37063((class_364)new WidgetColorButton(xOffset + 10, 88, 80, 20, (class_2561)class_2561.method_43471((String)"gui.worldcomment.list.my_posts"), -1739917, sender -> this.useSubScreen(2)));
        this.pageButtons[3] = (class_4185)this.method_37063((class_364)new WidgetColorButton(xOffset + 10, 122, 80, 20, (class_2561)class_2561.method_43471((String)"gui.worldcomment.list.detail"), -1739917, sender -> {}));
        for (int i = 0; i < this.pageButtons.length; ++i) {
            this.pageButtons[i].field_22763 = i != this.subScreen;
        }
        this.pageButtons[3].field_22764 = this.subScreen == 3;
    }

    void useSubScreen(int subScreen) {
        class_310 minecraft = class_310.method_1551();
        this.prevSubScreen = this.subScreen;
        this.subScreen = subScreen;
        if (this.prevSubScreen != 3 || this.commentList.isEmpty()) {
            switch (subScreen) {
                case 0: {
                    this.commentList.clear();
                    class_2338 playerPos = minecraft.field_1724.method_24515();
                    for (Map region : ClientWorldData.INSTANCE.regions.values()) {
                        for (Map.Entry blockData : region.entrySet()) {
                            for (CommentEntry comment : (List)blockData.getValue()) {
                                if (comment.deleted) continue;
                                this.commentList.add(comment);
                            }
                        }
                    }
                    this.commentList.sort(Comparator.comparingDouble(entry -> entry.location.method_10262((class_2382)playerPos)));
                    this.commentListOffset = 0;
                    break;
                }
                case 1: {
                    this.commentList.clear();
                    this.commentListOffset = 0;
                    this.lastRequestNonce = ServerWorldData.SNOWFLAKE.nextId();
                    this.latestCommentsRequestedAmount = 0;
                    PacketCollectionRequestC2S.ClientLogics.sendLatest(this.latestCommentsRequestedAmount, 20, this.lastRequestNonce);
                    this.latestCommentsRequestedAmount += 20;
                    break;
                }
                case 2: {
                    this.commentList.clear();
                    this.commentListOffset = 0;
                    this.lastRequestNonce = ServerWorldData.SNOWFLAKE.nextId();
                    PacketCollectionRequestC2S.ClientLogics.sendPlayer(minecraft.field_1724.method_7334().getId(), this.lastRequestNonce);
                }
            }
        }
        this.method_25426();
    }

    public void method_25394(class_332 guiParam, int mouseX, int mouseY, float partialTick) {
        class_332 guiGraphics = guiParam;
        class_310 minecraft = class_310.method_1551();
        this.method_25420(guiParam);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 1.0f);
        int commentEntryWidth = Math.min(this.field_22789 - 100 - 20 - 10, 250);
        int bookWidth = this.subScreen == 3 ? this.field_22789 : commentEntryWidth + 100 + 20 + 10;
        int xOffset = (this.field_22789 - bookWidth) / 2;
        int xOffsetR = this.field_22789 - xOffset;
        guiGraphics.method_51439(minecraft.field_1772, (class_2561)class_2561.method_43471((String)"gui.worldcomment.list.title"), xOffset + 40, 15, -6464, true);
        for (class_4185 button : this.pageButtons) {
            button.method_46421(xOffset + 10);
        }
        if (this.subScreen == 3) {
            boolean canDelete;
            CommentEntry comment = this.commentForDetail;
            int maxPicWidth = this.field_22789 - 100 - 20 - 20;
            int maxPicHeight = this.field_22790 - 30 - 20 - 20;
            int shadowColor = -16777216;
            int shadowOffset = 3;
            ImageDownload.ImageState imageToDraw = ImageDownload.getTexture(comment.image, false);
            int picWidth = Math.min(maxPicWidth, maxPicHeight * imageToDraw.width / imageToDraw.height);
            int picHeight = picWidth * imageToDraw.height / imageToDraw.width;
            int x1 = 110;
            int x2 = 110 + picWidth;
            int y1 = 40;
            int y2 = 40 + picHeight;
            guiGraphics.method_25294(x1 + shadowOffset, y1 + shadowOffset, x2 + shadowOffset, y2 + shadowOffset, shadowColor);
            RenderSystem.setShaderTexture((int)0, (int)imageToDraw.getFriendlyTexture(minecraft.method_1531()).method_4624());
            RenderSystem.setShader(class_757::method_34542);
            Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, 0.0f).method_22913(0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, 0.0f).method_22913(0.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, 0.0f).method_22913(1.0f, 0.0f).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            WidgetCommentEntry widget = this.getWidget(comment);
            widget.showImage = false;
            int imgAreaWidth = this.field_22789 - 100 - 20 - 10;
            widget.setBounds(110 + imgAreaWidth - imgAreaWidth / 2, 0, imgAreaWidth / 2);
            widget.setBounds(110 + imgAreaWidth - imgAreaWidth / 2, this.field_22790 - 20 - widget.method_25364(), imgAreaWidth / 2);
            widget.method_25394(guiParam, mouseX, mouseY, partialTick);
            boolean bl = canDelete = minecraft.field_1724.method_5687(3) || minecraft.field_1724.method_7334().getId().equals(comment.initiator);
            if (canDelete) {
                int deleteBtnX = 118;
                int deleteBtnY = this.field_22790 - 20 - 22;
                guiGraphics.method_25293(ATLAS_LOCATION, deleteBtnX, deleteBtnY, 20, 20, 216.0f, 60.0f, 20, 20, 256, 256);
                if (mouseX > deleteBtnX && mouseX < deleteBtnX + 20 && mouseY > deleteBtnY && mouseY < deleteBtnY + 20) {
                    guiGraphics.method_25293(ATLAS_LOCATION, deleteBtnX, deleteBtnY, 20, 20, 236.0f, 60.0f, 20, 20, 256, 256);
                    if (this.commentToDelete == comment) {
                        guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.worldcomment.list.remove.confirm"), mouseX, mouseY);
                    }
                }
            }
        } else {
            this.graphicsBlit9(guiGraphics, xOffset + 100, 30, bookWidth - 120, this.field_22790 - 50, 176, 40, 20, 20, 256, 256, 4, 4, 4, 4);
            guiGraphics.method_44379(0, 32, this.field_22789, this.field_22790 - 22);
            int yOffset = 36;
            for (int i = this.commentListOffset; i < this.commentList.size(); ++i) {
                boolean canDelete;
                CommentEntry comment = this.commentList.get(i);
                WidgetCommentEntry widget = this.getWidget(comment);
                widget.showImage = true;
                widget.setBounds(xOffset + 106, yOffset, bookWidth - 102 - 22 - 8 - 4 - 16);
                widget.method_25394(guiParam, mouseX, mouseY, partialTick);
                guiGraphics.method_25293(ATLAS_LOCATION, xOffsetR - 22 - 4 - 16, yOffset + 4, 16, 16, 196.0f, 60.0f, 20, 20, 256, 256);
                if (mouseX > xOffsetR - 22 - 4 - 16 && mouseX < xOffsetR - 22 - 4 && mouseY > yOffset + 4 && mouseY < yOffset + 4 + 16) {
                    guiGraphics.method_25293(ATLAS_LOCATION, xOffsetR - 22 - 4 - 16, yOffset + 4, 16, 16, 236.0f, 60.0f, 20, 20, 256, 256);
                }
                boolean bl = canDelete = minecraft.field_1724.method_5687(3) || minecraft.field_1724.method_7334().getId().equals(comment.initiator);
                if (canDelete) {
                    guiGraphics.method_25293(ATLAS_LOCATION, xOffsetR - 22 - 4 - 16, (yOffset += 16) + 4, 16, 16, 216.0f, 60.0f, 20, 20, 256, 256);
                    if (mouseX > xOffsetR - 22 - 4 - 16 && mouseX < xOffsetR - 22 - 4 && mouseY > yOffset + 4 && mouseY < yOffset + 4 + 16) {
                        guiGraphics.method_25293(ATLAS_LOCATION, xOffsetR - 22 - 4 - 16, yOffset + 4, 16, 16, 236.0f, 60.0f, 20, 20, 256, 256);
                        if (this.commentToDelete == comment) {
                            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.worldcomment.list.remove.confirm"), mouseX, mouseY);
                        }
                    }
                    yOffset -= 16;
                }
                if ((yOffset += widget.method_25364() + 6) > this.field_22790 - 22) break;
            }
            guiGraphics.method_44380();
            if (this.commentList.size() > 1) {
                String pageStr = String.format("\u2195 %d / %d", this.commentListOffset + 1, this.commentList.size());
                guiGraphics.method_51433(class_310.method_1551().field_1772, pageStr, xOffsetR - 10 - 10 - class_310.method_1551().field_1772.method_1727(pageStr), 15, -5908825, true);
            } else if (this.commentList.isEmpty()) {
                guiGraphics.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"gui.worldcomment.list.empty"), xOffset + 100 + (bookWidth - 120) / 2, 30 + (this.field_22790 - 50) / 2, -5908825);
            }
        }
        guiGraphics.method_51448().method_22909();
        super.method_25394(guiParam, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        block8: {
            int xOffsetR;
            block7: {
                boolean canDelete;
                int commentEntryWidth = Math.min(this.field_22789 - 100 - 20 - 10, 250);
                int bookWidth = this.subScreen == 3 ? this.field_22789 : commentEntryWidth + 100 + 20 + 10;
                int xOffset = (this.field_22789 - bookWidth) / 2;
                xOffsetR = this.field_22789 - xOffset;
                if (this.subScreen != 3) break block7;
                CommentEntry comment = this.commentForDetail;
                boolean bl = canDelete = this.field_22787.field_1724.method_5687(3) || this.field_22787.field_1724.method_7334().getId().equals(comment.initiator);
                if (!canDelete) break block8;
                int deleteBtnX = 118;
                int deleteBtnY = this.field_22790 - 20 - 22;
                if (!(mouseX > (double)deleteBtnX) || !(mouseX < (double)(deleteBtnX + 20)) || !(mouseY > (double)deleteBtnY) || !(mouseY < (double)(deleteBtnY + 20))) break block8;
                if (comment == this.commentToDelete) {
                    PacketEntryActionC2S.ClientLogics.send(comment, -1);
                    this.commentList.remove(comment);
                    this.commentToDelete = null;
                    this.commentListOffset = class_3532.method_15340((int)this.commentListOffset, (int)0, (int)Math.max(this.commentList.size() - 1, 0));
                    this.method_25419();
                } else {
                    this.commentToDelete = comment;
                }
                break block8;
            }
            int yOffset = 36;
            for (int i = this.commentListOffset; i < this.commentList.size(); ++i) {
                CommentEntry comment = this.commentList.get(i);
                WidgetCommentEntry widget = this.getWidget(comment);
                if (mouseX > (double)(xOffsetR - 22 - 4 - 16) && mouseX < (double)(xOffsetR - 22 - 4) && mouseY > (double)(yOffset + 4) && mouseY < (double)(yOffset + 4 + 16)) {
                    this.commentForDetail = comment;
                    this.useSubScreen(3);
                    return true;
                }
                yOffset += 16;
                if (mouseX > (double)(xOffsetR - 22 - 4 - 16) && mouseX < (double)(xOffsetR - 22 - 4) && mouseY > (double)(yOffset + 4) && mouseY < (double)(yOffset + 4 + 16)) {
                    if (comment == this.commentToDelete) {
                        PacketEntryActionC2S.ClientLogics.send(comment, -1);
                        this.commentList.remove(comment);
                        this.commentToDelete = null;
                        this.commentListOffset = class_3532.method_15340((int)this.commentListOffset, (int)0, (int)Math.max(this.commentList.size() - 1, 0));
                    } else {
                        this.commentToDelete = comment;
                    }
                    return true;
                }
                yOffset -= 16;
                if ((yOffset += widget.method_25364() + 6) > this.field_22790 - 22) break;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25420(class_332 guiParam) {
        class_332 guiGraphics = guiParam;
        super.method_25420(guiParam);
        int commentEntryWidth = Math.min(this.field_22789 - 100 - 20 - 10, 250);
        int bookWidth = this.subScreen == 3 ? this.field_22789 : commentEntryWidth + 100 + 20 + 10;
        int xOffset = (this.field_22789 - bookWidth) / 2;
        int xOffsetR = this.field_22789 - xOffset;
        this.graphicsBlit9(guiGraphics, xOffset + 30, 10, bookWidth - 40, this.field_22790 - 20, 196, 40, 20, 20, 256, 256, 4, 4, 4, 4);
        RenderSystem.enableBlend();
        guiGraphics.method_25294(xOffset + 30, 10, xOffset + 60, this.field_22790 - 10, 1725116207);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaY) {
        if (this.accumulatedScroll != 0.0 && Math.signum(deltaY) != Math.signum(this.accumulatedScroll)) {
            this.accumulatedScroll = 0.0;
        }
        this.accumulatedScroll += deltaY;
        int scrollAmount = (int)this.accumulatedScroll;
        if (scrollAmount == 0) {
            return super.method_25401(mouseX, mouseY, deltaY);
        }
        this.accumulatedScroll -= (double)scrollAmount;
        if (this.commentList.size() <= 1) {
            this.commentListOffset = 0;
            return super.method_25401(mouseX, mouseY, deltaY);
        }
        int dir = -((int)Math.signum(scrollAmount));
        this.commentListOffset = class_3532.method_15340((int)(this.commentListOffset + dir), (int)0, (int)Math.max(this.commentList.size() - 1, 0));
        if (this.subScreen == 1 && this.commentListOffset >= this.latestCommentsRequestedAmount - 10) {
            this.lastRequestNonce = ServerWorldData.SNOWFLAKE.nextId();
            PacketCollectionRequestC2S.ClientLogics.sendLatest(this.latestCommentsRequestedAmount, 20, this.lastRequestNonce);
            this.latestCommentsRequestedAmount += 20;
        }
        return true;
    }

    public void method_25419() {
        if (this.subScreen == 3 && this.prevSubScreen != 3) {
            this.useSubScreen(this.prevSubScreen);
        } else {
            super.method_25419();
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void handleCommentDataUI(List<CommentEntry> data, long nonce) {
        if (nonce != this.lastRequestNonce) {
            return;
        }
        this.commentList.addAll(data);
        this.commentList.sort(Comparator.comparingLong(entry -> -entry.timestamp));
        this.commentListOffset = class_3532.method_15340((int)this.commentListOffset, (int)0, (int)Math.max(this.commentList.size() - 1, 0));
    }

    public static void triggerOpen() {
        class_310 minecraft = class_310.method_1551();
        RenderSystem.recordRenderCall(() -> minecraft.method_18858(() -> {
            if (minecraft.field_1755 instanceof CommentListScreen) {
                minecraft.field_1755.method_25419();
            } else {
                minecraft.method_1507((class_437)new CommentListScreen(null));
            }
        }));
    }

    public static boolean handleKeyTab() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null) {
            return false;
        }
        if (ClientRayPicking.pickedComments.isEmpty()) {
            return false;
        }
        minecraft.execute(() -> {
            if (minecraft.field_1755 instanceof CommentListScreen) {
                minecraft.field_1755.method_25419();
            } else if (minecraft.field_1755 == null) {
                minecraft.method_1507((class_437)new CommentListScreen(ClientRayPicking.pickedComments.get(ClientRayPicking.overlayOffset)));
            }
        });
        return true;
    }
}

