/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.worldcomment.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.cn.zbx1425.worldcomment.Main;
import fabric.cn.zbx1425.worldcomment.MainClient;
import fabric.cn.zbx1425.worldcomment.data.CommentEntry;
import fabric.cn.zbx1425.worldcomment.data.client.Screenshot;
import fabric.cn.zbx1425.worldcomment.data.network.SubmitDispatcher;
import fabric.cn.zbx1425.worldcomment.data.network.SubmitJob;
import fabric.cn.zbx1425.worldcomment.gui.CommentTypeButton;
import fabric.cn.zbx1425.worldcomment.gui.IGuiCommon;
import fabric.cn.zbx1425.worldcomment.gui.ScreenshotConfigScreen;
import fabric.cn.zbx1425.worldcomment.gui.WidgetColorButton;
import fabric.cn.zbx1425.worldcomment.gui.WidgetFlagLabel;
import fabric.cn.zbx1425.worldcomment.gui.WidgetUnmanagedImage;
import fabric.cn.zbx1425.worldcomment.item.CommentToolItem;
import fabric.cn.zbx1425.worldcomment.util.OffHeapAllocator;
import fabric.cn.zbx1425.worldcomment.util.compat.Checkbox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_7529;
import net.minecraft.class_7919;

public class CommentToolScreen
extends class_437
implements IGuiCommon {
    private final byte[] imageBytes;
    private final boolean withPlacingDown;
    private static final int SIDEBAR_OFFSET = 100;
    private static final int CONTAINER_PADDING_X = 8;
    private static final int CONTAINER_PADDING_Y = 5;
    private List<CommentTypeButton> radioButtons = new ArrayList<CommentTypeButton>();
    private WidgetUnmanagedImage widgetImage;
    private class_7529 textBoxMessage;
    private class_4185 btnScreenshotConfig;
    private class_4286 checkBoxNoImage;
    private class_4286 checkBoxAnonymous;
    private WidgetColorButton btnSaveScreenshot;
    private class_4185 btnSendFeedback;
    private int selectedCommentType = 0;
    boolean screenshotSaved;
    public int containerWidth;
    public int containerHeight;
    public int containerOffsetX;
    public int containerOffsetY;
    private long timestampOpenGui = 0L;

    public CommentToolScreen(byte[] imageBytes, boolean withPlacingDown) {
        super((class_2561)class_2561.method_43470((String)"Comment Tool"));
        this.imageBytes = imageBytes;
        this.withPlacingDown = withPlacingDown;
        this.screenshotSaved = false;
        ByteBuffer offHeapBuffer = OffHeapAllocator.allocate(imageBytes.length);
        try {
            offHeapBuffer.put(imageBytes);
            offHeapBuffer.rewind();
            this.widgetImage = new WidgetUnmanagedImage(new class_1043(class_1011.method_4324((ByteBuffer)offHeapBuffer)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            OffHeapAllocator.free(offHeapBuffer);
        }
    }

    public void method_25419() {
        this.widgetImage.close();
        super.method_25419();
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        class_310 minecraft = class_310.method_1551();
        int baseY = 5;
        this.radioButtons.clear();
        assert (minecraft.field_1724 != null && minecraft.field_1761 != null);
        boolean canAccessBuildTools = MainClient.CLIENT_CONFIG.canAccessBuildMarkers(minecraft);
        for (int r = 0; r < (canAccessBuildTools ? 2 : 1); ++r) {
            this.method_37063((class_364)new WidgetFlagLabel(96, baseY, CommentTypeButton.BTN_WIDTH * 4 + 10, 10, -14575885, (class_2561)class_2561.method_43471((String)("gui.worldcomment.comment_type.r" + (r + 1)))));
            for (int c = 0; c < 4; ++c) {
                CommentTypeButton selectBtn = new CommentTypeButton(100 + CommentTypeButton.BTN_WIDTH * c, baseY + 10, r * 4 + c + 1, sender -> {
                    this.selectedCommentType = ((CommentTypeButton)sender).commentType;
                    for (CommentTypeButton radioButton : this.radioButtons) {
                        radioButton.field_22763 = radioButton.commentType != this.selectedCommentType;
                    }
                    this.updateBtnSendFeedback();
                });
                selectBtn.field_22763 = selectBtn.commentType != this.selectedCommentType;
                this.method_37063((class_364)selectBtn);
                this.radioButtons.add(selectBtn);
            }
            baseY += CommentTypeButton.BTN_HEIGHT + 10;
        }
        if (!canAccessBuildTools) {
            baseY += 10;
        }
        this.method_37063((class_364)new WidgetFlagLabel(96, baseY, CommentTypeButton.BTN_WIDTH * 5 + 10, 10, -16728876, (class_2561)class_2561.method_43471((String)"gui.worldcomment.message")));
        this.textBoxMessage = new class_7529(class_310.method_1551().field_1772, 100, baseY += 10, CommentTypeButton.BTN_WIDTH * 5, 80, (class_2561)class_2561.method_43471((String)"gui.worldcomment.message.placeholder"), (class_2561)class_2561.method_43470((String)""));
        this.textBoxMessage.method_44400("");
        this.textBoxMessage.method_44401(ignored -> this.updateBtnSendFeedback());
        this.method_37063((class_364)this.textBoxMessage);
        baseY += this.textBoxMessage.method_25364();
        this.btnSendFeedback = new WidgetColorButton(100 + CommentTypeButton.BTN_WIDTH * 3, baseY += 5, CommentTypeButton.BTN_WIDTH * 2, 20, (class_2561)class_2561.method_43471((String)"gui.worldcomment.submit"), -3808859, sender -> this.sendReport());
        this.updateBtnSendFeedback();
        this.method_37063((class_364)this.btnSendFeedback);
        baseY = 5;
        this.widgetImage.setBounds(0, baseY, 80);
        this.method_37063((class_364)this.widgetImage);
        this.btnScreenshotConfig = new WidgetColorButton(0, baseY += this.widgetImage.method_25364() + 10, CommentTypeButton.BTN_WIDTH * 2, 20, (class_2561)class_2561.method_43471((String)"gui.worldcomment.screenshot_config"), -5592406, sender -> minecraft.method_1507((class_437)new ScreenshotConfigScreen()));
        this.method_37063((class_364)this.btnScreenshotConfig);
        this.checkBoxNoImage = Checkbox.builder((class_2561)class_2561.method_43471((String)"gui.worldcomment.exclude_screenshot"), minecraft.field_1772).pos(0, baseY += 30).selected(false).build();
        this.method_37063((class_364)this.checkBoxNoImage);
        this.checkBoxAnonymous = Checkbox.builder((class_2561)class_2561.method_43471((String)"gui.worldcomment.anonymous"), minecraft.field_1772).pos(0, baseY += 20).selected(false).build();
        this.method_37063((class_364)this.checkBoxAnonymous);
        this.containerWidth = 96 + CommentTypeButton.BTN_WIDTH * 5 + 10;
        this.containerHeight = this.btnSendFeedback.method_46427() + this.btnSendFeedback.method_25364();
        this.containerOffsetX = (this.field_22789 - (this.containerWidth + 16)) / 2 + 8;
        this.containerOffsetY = (this.field_22790 - (this.containerHeight + 10)) / 2 + 5;
        for (class_364 child : this.method_25396()) {
            class_339 widget = (class_339)child;
            widget.method_46421(widget.method_46426() + this.containerOffsetX);
            widget.method_46419(widget.method_46427() + this.containerOffsetY);
        }
        this.btnSaveScreenshot = new WidgetColorButton(this.containerOffsetX, this.btnSendFeedback.method_46427(), CommentTypeButton.BTN_WIDTH * 2, 20, (class_2561)class_2561.method_43471((String)"gui.worldcomment.save_screenshot"), -8268550, sender -> {
            Path persistentPath = Screenshot.getAvailableFile().toPath();
            try {
                Files.write(persistentPath, this.imageBytes, new OpenOption[0]);
                this.screenshotSaved = true;
                this.btnSaveScreenshot.field_22763 = false;
            }
            catch (IOException e) {
                Main.LOGGER.error("Copy image", (Throwable)e);
            }
        });
        this.btnSaveScreenshot.field_22763 = !this.screenshotSaved;
        this.method_37063((class_364)this.btnSaveScreenshot);
    }

    private void sendReport() {
        if (this.selectedCommentType == 0) {
            return;
        }
        class_310.method_1551().execute(() -> {
            class_746 player = class_310.method_1551().field_1724;
            CommentEntry comment = new CommentEntry((class_1657)player, this.checkBoxAnonymous.method_20372(), this.selectedCommentType, this.textBoxMessage.method_44405());
            long jobId = SubmitDispatcher.addJob(comment, this.checkBoxNoImage.method_20372() ? null : this.imageBytes, (arg_0, arg_1) -> CommentToolScreen.lambda$sendReport$6((class_1657)player, arg_0, arg_1));
            if (!this.withPlacingDown) {
                SubmitDispatcher.placeJobAt(jobId, player.method_24515().method_33096((int)Math.round(player.method_19538().field_1351 - 0.0625)));
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"gui.worldcomment.send_pending"), false);
                class_1799 item = CommentToolItem.Client.getHoldingCommentTool();
                if (item != null) {
                    CommentToolItem.setUploadJobId(item, jobId);
                }
            }
        });
        this.method_25419();
    }

    public void method_25394(class_332 guiParam, int mouseX, int mouseY, float partialTick) {
        class_332 guiGraphics = guiParam;
        this.method_25420(guiParam);
        guiGraphics.method_51448().method_22903();
        boolean animationDone = this.setupAnimationTransform(guiGraphics);
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 1.0f);
        super.method_25394(guiParam, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22909();
    }

    public void method_25420(class_332 guiParam) {
        class_332 guiGraphics = guiParam;
        super.method_25420(guiParam);
        guiGraphics.method_51448().method_22903();
        this.setupAnimationTransform(guiGraphics);
        RenderSystem.enableBlend();
        guiGraphics.method_25294(this.containerOffsetX - 8, this.containerOffsetY - 5, this.containerOffsetX + this.containerWidth + 8, this.containerOffsetY + this.containerHeight + 5, -1725816286);
        guiGraphics.method_25294(this.containerOffsetX - 8, this.containerOffsetY + this.containerHeight - 20 + 5, this.containerOffsetX + this.containerWidth + 8, this.containerOffsetY + this.containerHeight + 5, 1716809338);
        guiGraphics.method_51448().method_22909();
    }

    private boolean setupAnimationTransform(class_332 guiGraphics) {
        float y2;
        float y1;
        float x2;
        float x1;
        long timestampNow = System.currentTimeMillis();
        if (this.timestampOpenGui == 0L) {
            this.timestampOpenGui = timestampNow;
        }
        float animProgress = class_3532.method_15363((float)((float)(timestampNow - this.timestampOpenGui) / 600.0f), (float)0.0f, (float)1.0f);
        float s1PadW = (float)this.field_22789 / 10.0f;
        float s1PadH = (float)this.field_22790 / 10.0f;
        if ((double)animProgress < 0.4) {
            float subProgress = (float)class_3532.method_33722((double)animProgress, (double)0.0, (double)0.4, (double)0.0, (double)1.0);
            easedProgress = 1.0f - (float)Math.pow(1.0f - subProgress, 3.0);
            x1 = class_3532.method_16439((float)easedProgress, (float)0.0f, (float)s1PadW);
            x2 = class_3532.method_16439((float)easedProgress, (float)this.field_22789, (float)((float)this.field_22789 - s1PadW));
            y1 = class_3532.method_16439((float)easedProgress, (float)0.0f, (float)s1PadH);
            y2 = class_3532.method_16439((float)easedProgress, (float)this.field_22790, (float)((float)this.field_22790 - s1PadH));
        } else if (animProgress < 1.0f) {
            float x = (float)class_3532.method_33722((double)animProgress, (double)0.4, (double)1.0, (double)0.0, (double)1.0);
            easedProgress = x < 0.5f ? 4.0f * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0f;
            x1 = class_3532.method_16439((float)easedProgress, (float)s1PadW, (float)this.containerOffsetX);
            x2 = class_3532.method_16439((float)easedProgress, (float)((float)this.field_22789 - s1PadW), (float)(this.containerOffsetX + this.widgetImage.method_25368()));
            y1 = class_3532.method_16439((float)easedProgress, (float)s1PadH, (float)(this.containerOffsetY + 5));
            y2 = class_3532.method_16439((float)easedProgress, (float)((float)this.field_22790 - s1PadH), (float)(this.containerOffsetY + 5 + this.widgetImage.method_25364()));
        } else {
            return true;
        }
        float scaleX = (x2 - x1) / (float)this.widgetImage.method_25368();
        float scaleY = (y2 - y1) / (float)this.widgetImage.method_25364();
        guiGraphics.method_51448().method_46416(x1, y1, 0.0f);
        guiGraphics.method_51448().method_22905(scaleX, scaleY, 1.0f);
        guiGraphics.method_51448().method_46416((float)(-this.containerOffsetX), (float)(-(this.containerOffsetY + 5)), 0.0f);
        return false;
    }

    public boolean method_25421() {
        return false;
    }

    private void updateBtnSendFeedback() {
        if (this.selectedCommentType == 0) {
            this.btnSendFeedback.field_22763 = false;
            this.btnSendFeedback.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.worldcomment.require_comment_type").method_27692(class_124.field_1061)));
        } else if (this.textBoxMessage.method_44405().length() > 256) {
            this.btnSendFeedback.field_22763 = false;
            this.btnSendFeedback.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.worldcomment.message_too_long").method_27692(class_124.field_1061)));
        } else {
            this.btnSendFeedback.field_22763 = true;
            this.btnSendFeedback.method_47400(null);
        }
    }

    private static /* synthetic */ void lambda$sendReport$6(class_1657 player, SubmitJob job, Throwable ex) {
        class_310.method_1551().execute(() -> {
            if (job == null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"gui.worldcomment.send_finish"), false);
            } else if (ex != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"gui.worldcomment.send_fail", (Object[])new Object[]{ex.getClass().getName() + ": " + ex.getMessage()}), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"gui.worldcomment.send_upload_incomplete"), false);
            }
        });
    }
}

